
<lido:lidoWrap
    xmlns:lido="http://www.lido-schema.org"
    xmlns:gml="http://www.opengis.net/gml"
    xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" 
	xsi:schemaLocation="http://www.lido-schema.org http://www.lido-schema.org/schema/v1.1/lido-v1.1.xsd
	http://www.opengis.net/gml http://schemas.opengis.net/gml/3.1.1/base/feature.xsd">	
      <lido:lido> 		
        <!--collection tai item, riippuen siitä, mitä tasoa kuvataan-->
        <!-- type-attribuutin arvo kokoelmahierarkian ylimmällä tasolla "collection" Hierarkiassa voi olla vain yksi collection-taso, jonka tietueelle otetaan käyttöön kokoelmasivupohja--> 
        <!-- type-attribuutin arvo kokoelmahierarkian välitasoilla "item"--> 
        <!--type-attribuutin arvo moniosaisen objektin ylimmällä kokoavalla tasolla voi olla "item"-->
        <!--type-attribuutin arvo yksittäisen objektin tietueessa "item"-->
        <lido:lidoRecID lido:type="item tai collection"><!--tietueen tunniste--></lido:lidoRecID>
        <lido:applicationProfile lido:type="URI"><!--järjestelmä, jolle LIDO-pohja on luotu esim. https://www.finna.fi--></lido:applicationProfile>   
        <lido:descriptiveMetadata xml:lang="fi">
            <lido:objectClassificationWrap>
                <lido:objectWorkTypeWrap>
                    <!--Tämän elementin perusteella aineisto mapataan Finnassa aineistotyppeihin. Termin tulisi olla aineistolähtöinen. Huomaa, että Kuva-terminä Finnassa on liian yleinen, sillä se käsittää kaiken kuvallisen aineiston. Sama koskee termiä Arkistomateriaali.-->
                    <lido:objectWorkType>
                        <lido:term>
                            <!-- objektityyppi esim. Esine, Valokuva, Maalaus, Kirje, Pienpainate-->
                        </lido:term>
                    </lido:objectWorkType>
                </lido:objectWorkTypeWrap>
                <lido:classificationWrap>
                     <lido:classification lido:type="language">
				 			<lido:term lido:label="esim. tekstitys, sisällön kieli">
                            <!--kielen ISO standardin mukainen koodi. HUOM! Tarkoittaa kuvailun kohteena olevan objektin, esim tekstidokumentin kieltä.-->  
                            </lido:term> 
                     </lido:classification>
                    <lido:classification lido:type="1. luokituksen tyyppi englanniksi, esim language, style, form, colour content, genre">
                    <!--luokitus: järjestelmän nimi, URI ja termi-->
                        <lido:conceptID lido:source="1. luokitusjärjestelmän nimi" lido:type="URI"><!--1. luokituksen termin URI, jos termi julkaistu verkossa--></lido:conceptID>
                        <lido:term lido:label="luokitus" xml:lang="fi"><!--1. luokituksen termi--></lido:term>
                        <lido:term lido:label="luokitus" xml:lang="en"><!--1. luokituksen termi--></lido:term>
                        <lido:term lido:label="luokitus" xml:lang="sv"><!--1. luokituksen termi--></lido:term>
                    </lido:classification>                  
                    <lido:classification lido:type="language">
                        <lido:term>
                            <!--Kielen ISO standardin mukainen koodi. HUOM! Tarkoittaa kuvailun kohteena olevan objektin, esim tekstidokumentin kieltä.-->
                        </lido:term>
                    </lido:classification>
                </lido:classificationWrap>
            </lido:objectClassificationWrap>
            <lido:objectIdentificationWrap>
                <lido:titleWrap>
                    <lido:titleSet lido:type="title">
                    <!--objektin nimi, nimeke, otsikko"-->
                    <!--Ensisijaiset otsikot voi merkitä "preferred" ja toissijaiset "alternate"-attribuuteilla esim. -->
                             <!--titleSet type="title">
                             <appellationValue lang="fi" pref="preferred" label="nimi"><Porkkalan palautussopimuksen allekirjoitus Helsingissä></appellationValue>
                             <appellationValue lang="en" pref="alternate" label="title"><Signing of the restitution contract of Porkkala in Helsinki></appellationValue>
                             <appellationValue lang="sv" pref="alternate" label="titel"/>
                             </titleSet-->
                        <lido:appellationValue xml:lang="fi" lido:label="nimi">
                            <!--nimi, nimeke, otsikko-->
                        </lido:appellationValue>
                        <lido:appellationValue xml:lang="en" lido:label="title">
                            <!--nimi, nimeke, otsikko englanniksi-->
                        </lido:appellationValue>
                         <lido:appellationValue xml:lang="sv" lido:label="rubrik">
                            <!--nimi, nimeke, otsikko ruotsiksi-->
                        </lido:appellationValue>
                    </lido:titleSet>
                    <lido:titleSet lido:type="subtitle">
                    <!--objektin tarkentava nimi/nimeke, esim. alaotsikko-->
                        <lido:appellationValue xml:lang="fi" lido:label="tarkentava nimi">
                            <!-- tarkentava nimi/nimeke, esim. alaotsikko-->
                        </lido:appellationValue>
                        <lido:appellationValue xml:lang="en" lido:label="subtitle">
                            <!--tarkentava nimi/nimeke, esim. alaotsikko englanniksi-->
                        </lido:appellationValue>
                        <lido:appellationValue xml:lang="sv" lido:label="underrubrik">
                            <!--tarkentava nimi/nimeke, esim. alaotsikko ruotsiksi-->
                        </lido:appellationValue>
                    </lido:titleSet>
                </lido:titleWrap> 
                <lido:inscriptionsWrap>
                <!--objektissa olevan merkinnän kuvaus esim. leima, kirjoitus-->
                    <lido:inscriptions>
                    <!--1. merkintä-->
                        <lido:inscriptionDescription lido:type="tyyppi">
                            <lido:descriptiveNoteValue lido:label="merkinnän tyyppi">
                                <!--merkinnän muoto tai tyyppi esim. kaiverrus tai leima-->
                            </lido:descriptiveNoteValue>
                        </lido:inscriptionDescription>
                        <lido:inscriptionDescription lido:type="tekniikka">
                            <lido:descriptiveNoteValue lido:label="merkinnän tekniikka">
                                <!--menetelmä, jolla merkintä on tehty objektiin esim. kaiverrus, ompelu-->
                            </lido:descriptiveNoteValue>
                        </lido:inscriptionDescription>
                        <lido:inscriptionDescription lido:type="sijainti">
                            <lido:descriptiveNoteValue lido:label="merkinnän sijainti">
                                <!--kohta tai osa objektista, jossa merkintä sijaitsee esim. pohja, kädensija-->
                            </lido:descriptiveNoteValue>
                        </lido:inscriptionDescription>
                        <lido:inscriptionDescription lido:type="kuvailu">
                            <lido:descriptiveNoteValue lido:label="merkinnän kuvailu">
                                <!--objektissa olevan merkinnän kuvailu esim. leijonan pää ympyrän sisällä-->
                            </lido:descriptiveNoteValue>
                        </lido:inscriptionDescription>
                    </lido:inscriptions>
                    <lido:inscriptions>
                    <!--2. merkintä-->
                        <lido:inscriptionDescription lido:type="tyyppi">
                            <lido:descriptiveNoteValue lido:label="merkinnän tyyppi">
                                <!--merkinnän muoto tai tyyppi esim. kaiverrus tai leima-->
                            </lido:descriptiveNoteValue>
                        </lido:inscriptionDescription>
                        <lido:inscriptionDescription lido:type="tekniikka">
                            <lido:descriptiveNoteValue lido:label="merkinnän tekniikka">
                                <!--menetelmä, jolla merkintä on tehty objektiin esim. kaiverrus, ompelu-->
                            </lido:descriptiveNoteValue>
                        </lido:inscriptionDescription>
                        <lido:inscriptionDescription lido:type="sijainti">
                            <lido:descriptiveNoteValue lido:label="merkinnän sijainti">
                                <!--kohta tai osa objektista, jossa merkintä sijaitsee esim. pohja, kädensija-->
                            </lido:descriptiveNoteValue>
                        </lido:inscriptionDescription>
                        <lido:inscriptionDescription lido:type="kuvailu">
                            <lido:descriptiveNoteValue lido:label="merkinnän kuvailu">
                                <!--objektissa olevan merkinnän kuvailu esim. leijonan pää ympyrän sisällä-->
                            </lido:descriptiveNoteValue>
                        </lido:inscriptionDescription>
                    </lido:inscriptions>
                </lido:inscriptionsWrap>
                <lido:repositoryWrap>
                    <lido:repositorySet>
                        <lido:repositoryName>
                            <lido:legalBodyName>
                                <lido:appellationValue>
                                    <!--vastuumuseon nimi-->
                                </lido:appellationValue>
                            </lido:legalBodyName>
                            <lido:legalBodyWeblink>
                                <!--vastuumuseon www-osoite-->
                            </lido:legalBodyWeblink>
                        </lido:repositoryName>
                        <lido:workID>
                            <!--objektin päänumero, inventaarionumero, arkistotunnus tms.-->
                        </lido:workID>
                    </lido:repositorySet>
                </lido:repositoryWrap>                
                <lido:displayStateEditionWrap>
                <!--objektin esim. valokuvateoksen, veistoksen tai grafiikan teoksen yksilöllinen editionumero, kun objektia on rajattu erä tai erityispainos-->
                       <lido:displayEdition><!--editionumero--></lido:displayEdition>
                </lido:displayStateEditionWrap>                
                <lido:objectDescriptionWrap>
                 <!-- objektin fyysinen kuvaus (ulkoasun tai ulkonäön sanallinen kuvaus) ja sisällön kuvaus (sanallinen, yleisluontoinen kuvaus objektista tai objektissa kuvaillusta asiasta) -->
                    <lido:objectDescriptionSet lido:type="description">
                        <lido:descriptiveNoteValue xml:lang="fi" lido:label="kuvaus">
                            <!--objektin sanallinen kuvaus-->
                        </lido:descriptiveNoteValue>
                        <lido:descriptiveNoteValue xml:lang="en" lido:label="description">
                            <!--objektin sanallinen kuvaus englanniksi-->
                        </lido:descriptiveNoteValue>
                        <lido:descriptiveNoteValue xml:lang="sv" lido:label="beskrivning">
                            <!--objektin sanallinen kuvaus englanniksi-->
                        </lido:descriptiveNoteValue>
                    </lido:objectDescriptionSet>                    
                    <!--yksittäisen objektin/teoksen esittelytekstit, joka täydentää objektin peruskuvausta esim. näyttelyssä objektia kuvannut teksti-->
                    <lido:objectDescriptionSet lido:type="introduction">
                        <lido:descriptiveNoteValue xml:lang="fi" lido:label="esittely">
                            <!--objektin/teoksen esittelyteksti suomeksi-->
                        </lido:descriptiveNoteValue>
                        <lido:descriptiveNoteValue xml:lang="en" lido:label="introduction">
                            <!--objektin/teoksen esittelyteksti englanniksi-->
                        </lido:descriptiveNoteValue>
                        <lido:descriptiveNoteValue xml:lang="sv" lido:label="introduktion">
                            <!--objektin/teoksen esittelyteksti englanniksi-->
                        </lido:descriptiveNoteValue>
                    </lido:objectDescriptionSet>                  
                   <!--mahdollistaa erillisen oikeustiedon asettamisen objektin kuvaukselle 
                    Allows for setting separate rights information for the object description-->
                   <lido:objectDescriptionSet lido:type="oikeudet">
                        <lido:objectDescriptionRights>                       
                        </lido:objectDescriptionRights>
                    </lido:objectDescriptionSet>                     
                </lido:objectDescriptionWrap>                                              
                <lido:objectMeasurementsWrap>
                <!--objektin mitattava ominaisuus, kuten pituus, paino, koko-->
                    <lido:objectMeasurementsSet>
                    <!--elementtiä voi toistaa objektin eri osille, yhteen osaan liittyvät mitat yhdessä elementissä-->
                       <lido:displayObjectMeasurements xml:lang="fi">
                            <!--objektin mitat koostettuna muodossa 12 x 34 x 56 cm, näytetään käyttöliittymässä. esim. koko: 20,0 x 10,0 x 45,0 cm-->
                        </lido:displayObjectMeasurements>
                        <lido:displayObjectMeasurements xml:lang="en">
                            <!--objektin mitat koostettuna muodossa 12 x 34 x 56 cm, näytetään käyttöliittymässä. esim. size: 20,0 x 10,0 x 45,0 cm-->
                        </lido:displayObjectMeasurements>
                        <lido:displayObjectMeasurements xml:lang="sv">
                            <!--objektin mitat koostettuna muodossa 12 x 34 x 56 cm, näytetään käyttöliittymässä. esim.storlek: 20,0 x 10,0 x 45,0 cm-->
                        </lido:displayObjectMeasurements>                        
                           <lido:objectMeasurements>
                            <lido:measurementsSet>
                                <!--objektin mitta, toista measurementsSetiä, jokaiselle eri tyyppiselle mitalle oma-->                   
                                <lido:measurementType xml:lang="fi">esim. korkeus</lido:measurementType>
                                <lido:measurementType xml:lang="en">e.g. height</lido:measurementType> 
                                <lido:measurementType xml:lang="sv">t.ex höjd</lido:measurementType>                                                                  
                                <lido:measurementUnit>esim. cm</lido:measurementUnit>
                                <lido:measurementValue><!--arvo--></lido:measurementValue> 
                            </lido:measurementsSet> 
                            <!--kommentti objektin mitoista esim. viittaus objektin osaan, huomio minimi- ja maksiarvoista, tarkkuus-->
                            <lido:extentMeasurements>esim. ilman kantta</lido:extentMeasurements> 
                         </lido:objectMeasurements>                           
                        </lido:objectMeasurementsSet>                        
                         <lido:objectMeasurementsSet>    
                          <lido:objectMeasurements>                            
                            <lido:measurementsSet>
                                <!--objektin mitta, toista measurementsSetiä, jokaiselle eri tyyppiselle mitalle oma-->                   
                                <lido:measurementType xml:lang="fi">esim. leveys</lido:measurementType>
                                <lido:measurementType xml:lang="en">e.g. width</lido:measurementType> 
                                <lido:measurementType xml:lang="sv">t.ex bredd</lido:measurementType>                                                                  
                                <lido:measurementUnit>esim. cm</lido:measurementUnit>
                                <lido:measurementValue><!--arvo--></lido:measurementValue> 
                            </lido:measurementsSet>
                            <!--kommentti objektin mitoista esim, viittaus objektin osaan, huomio minimi- ja maksiarvoista, tarkkuus-->
                            <lido:extentMeasurements>esim. minimiarvo</lido:extentMeasurements>
                          </lido:objectMeasurements> 
                         </lido:objectMeasurementsSet>                          
                          <lido:objectMeasurementsSet> 
                           <lido:objectMeasurements>             
                           <lido:measurementsSet>
                                <!--objektin mitta, toista measurementsSetiä, jokaiselle eri tyyppiselle mitalle oma-->                   
                                <lido:measurementType xml:lang="fi">esim. syvyys</lido:measurementType>
                                <lido:measurementType xml:lang="en">e.g. depth</lido:measurementType> 
                                <lido:measurementType xml:lang="sv">t.ex djup</lido:measurementType>                                                                  
                                <lido:measurementUnit>esim. cm</lido:measurementUnit>
                                <lido:measurementValue><!--arvo--></lido:measurementValue> 
                            </lido:measurementsSet> 
                            <!--kommentti objektin mitoista esim, viittaus objektin osaan, huomio minimi- ja maksiarvoista, tarkkuus-->                    
                             <lido:extentMeasurements>esim. noin</lido:extentMeasurements>                         
                            </lido:objectMeasurements>                                                    
                      </lido:objectMeasurementsSet> 
                      <lido:objectMeasurementsSet >
                        <lido:displayObjectMeasurements>
                            <!--Kokonaisuuden laajuus koostettuna. Näytetään käyttöliittymässä. Jos taustajärjestelmässä laajuus on ilmaistu useassa kentässä, voidaan LIDOon tuoda arvot erillisillä objectMeasurements -elementeillä, ks. alla-->
                        </lido:displayObjectMeasurements>                        
                        <lido:objectMeasurements>  
                           <lido:measurementsSet>
                                <!--Laajuuden tyyppi, esim hyllymetriä, objektia jne. Toista measurementsSetiä, jokaiselle eri tyyppiselle mitalle oma-->                   
                                <lido:measurementType>
                                       <lido:conceptID lido:type="URI" lido:source="Metadata thesaurus">http://urn.fi/URN:NBN:fi:au:mts:m8</lido:conceptID>
                                       <lido:term xml:lang="en">extent</lido:term>
                                </lido:measurementType>                                                                     
                                <lido:measurementUnit xml:lang="fi">kpl</lido:measurementUnit>
                                <lido:measurementUnit xml:lang="en">pcs</lido:measurementUnit>
                                <lido:measurementUnit xml:lang="sv">st</lido:measurementUnit>
                                <lido:measurementValue><!--lukumäärä kappaleina--></lido:measurementValue>                            
                            </lido:measurementsSet>                         
                            <lido:measurementsSet>
                                <!--Laajuuden tyyppi, esim hyllymetriä, objektia jne. Toista measurementsSetiä, jokaiselle eri tyyppiselle mitalle oma-->                   
                                <lido:measurementType>
                                       <lido:conceptID lido:type="URI" lido:source="Metadata thesaurus">http://urn.fi/URN:NBN:fi:au:mts:m8</lido:conceptID>
                                       <lido:term xml:lang="en">extent</lido:term>
                                </lido:measurementType>                                                                     
                                <lido:measurementUnit xml:lang="fi">yksikköä</lido:measurementUnit>
                                <lido:measurementUnit xml:lang="en">unit</lido:measurementUnit>
                                <lido:measurementUnit xml:lang="sv">enhet</lido:measurementUnit>
                                <lido:measurementValue><!--määrä yksikköinä--></lido:measurementValue>                            
                            </lido:measurementsSet>
                            <lido:measurementsSet>
                                <!--Laajuuden tyyppi, esim hyllymetriä, objektia jne. Toista measurementsSetiä, jokaiselle eri tyyppiselle mitalle oma-->                   
                                <lido:measurementType>
                                       <lido:conceptID lido:type="URI" lido:source="Metadata thesaurus">http://urn.fi/URN:NBN:fi:au:mts:m8</lido:conceptID>
                                       <lido:term xml:lang="en">extent</lido:term>
                                </lido:measurementType>                                                                     
                                <lido:measurementUnit xml:lang="fi">hyllymetriä</lido:measurementUnit>
                                <lido:measurementUnit xml:lang="en">shelf meter</lido:measurementUnit>
                                <lido:measurementUnit xml:lang="sv">hyllmeter</lido:measurementUnit>
                                <lido:measurementValue><!--laajuus hyllymetreinä--></lido:measurementValue>                            
                            </lido:measurementsSet>
                            <lido:measurementsSet>
                                <!--Laajuuden tyyppi, esim hyllymetriä, objektia jne. Toista measurementsSetiä, jokaiselle eri tyyppiselle mitalle oma-->                   
                                <lido:measurementType>
                                       <lido:conceptID lido:type="URI" lido:source="Metadata thesaurus">http://urn.fi/URN:NBN:fi:au:mts:m8</lido:conceptID>
                                       <lido:term xml:lang="en">extent</lido:term>
                                </lido:measurementType>                                                                     
                                <lido:measurementUnit xml:lang="fi">kuvatyyppi</lido:measurementUnit>
                                <lido:measurementUnit xml:lang="en">image type</lido:measurementUnit>
                                <lido:measurementUnit xml:lang="sv">bildtyp</lido:measurementUnit>
                                <lido:measurementValue><!-- kuvatyyppien lukumäärä--></lido:measurementValue>                            
                            </lido:measurementsSet>
                        </lido:objectMeasurements>                         
                    </lido:objectMeasurementsSet>                   
			    </lido:objectMeasurementsWrap>                
                <lido:objectMaterialsTechWrap>
                <!--objektin materiaali- ja tekniikkatietoja esim. puu, käsityö-->
                      <lido:objectMaterialsTechSet>
                      <!--elementtiä voi toistaa objektin eri osille, yhteen osaan liittyvät tiedot materiaaleista ja tekniikoista yhdessä elementissä--> 
                            <lido:displayMaterialsTech>
                            <!--objektin materiaalit ja tekniikat koostettuna, näytetään käyttöliittymässä-->
                            </lido:displayMaterialsTech>
                            <lido:materialsTech>
                            <!--jäsennellyt tiedot materiaaleista ja tekniikoista-->                            
                                  <lido:termMaterialsTech lido:type="xxx">
                                  <!--objektin materiaali/tekniikka; type-attribuuttina esim. pohjamateriaali ja terminä esim. paperi-->
                                         <lido:term><!--esim. paperi--></lido:term>
                                  </lido:termMaterialsTech>
                                  <lido:extentMaterialsTech>
                                  <!--objektin osa, jonka materiaalista/tekniikasta on kyse-->
                                  </lido:extentMaterialsTech>
                                  <lido:sourceMaterialsTech>
                                  <!--materiaalia tai tekniikkaa koskevan tiedon lähde-->
                                  </lido:sourceMaterialsTech> 
                                  <!--Objektin värillisyys, toista termMaterialsTech-elementti jokaiselle eri värille-->
                                  <lido:termMaterialsTech lido:type="color name">
								  <lido:conceptID lido:type="URI" lido:source="koko"><!--väriominaisuuden termin URI, jos termi julkaistu verkossa esim. http://www.yso.fi/onto/koko/p69671--></lido:conceptID>
                                       <lido:term xml:lang="fi"><!--värillisyyttä kuvaava termi suomeksi esim. oranssi--></lido:term>
									   <lido:term xml:lang="en"><!--värillisyyttä kuvaava termi englanniksi esim. orange--></lido:term>
									   <lido:term xml:lang="sv"><!--värillisyyttä kuvaava termi ruotsiksi esim. orange--></lido:term>
                                  </lido:termMaterialsTech>
                            </lido:materialsTech>                                                 
                      </lido:objectMaterialsTechSet>              
               </lido:objectMaterialsTechWrap>                
            </lido:objectIdentificationWrap>
            <lido:eventWrap>
                <!--valmistustiedot, käyttötiedot, näyttelyt, konservointi jne.-->
                <!--http://terminology-view.lido-schema.org/vocnet/?startNode=lido00409&lang=en&uriVocItem=http://terminology.lido-schema.org/eventType-->                             
                <lido:eventSet>
                    <lido:event>
                        <lido:eventType>
                        <!--tietoja objektin valmistamisesta tai luomisesta-->
                            <lido:term>valmistus</lido:term>
                        </lido:eventType>
                        <lido:eventActor>
                        <!--valmistukseen liittyvä toimija, toista elementtiä, jos toimijoita on useita.-->
                            <lido:actorInRole>
                                <lido:actor>
                                   <!--auktoriteettitiedoista tai muista lähteistä peräisin oleva tunniste-->
                                    <lido:actorID lido:type= "URI" lido:source= "kanto">esim. http://urn.fi/URN:NBN:fi:au:finaf:000068760</lido:actorID>
                                    <lido:nameActorSet>
                                        <lido:appellationValue>
                                            <!--valmistajan nimi-->
                                        </lido:appellationValue>
                                    </lido:nameActorSet>                                    
                                    <lido:nationalityActor>
                                          <lido:term><!--valmistajan kansallisuus--></lido:term>
                                   </lido:nationalityActor>                           
                                   <lido:vitalDatesActor>
                                        <!--valmistajan elinaika-->
                                        <lido:earliestDate lido:type="xxx">
                                            <!--valmistajan syntymäaika/syntymävuosi-->
                                        </lido:earliestDate>
                                        <lido:latestDate lido:type="xxx">
                                            <!--valmistajan kuolinaika/kuolinvuosi-->
                                        </lido:latestDate>
                                    </lido:vitalDatesActor>
                                   <lido:vitalPlaceActor lido:type="xxx">
                                   <!--valmistajan syntymä-/kuolinpaikka tai toimintapaikka-->
                                       <lido:placeID lido:type="esim. URI">
                                       <!--paikan yksilöllinen tunniste-->
                                       </lido:placeID>
                                       <lido:namePlaceSet>
                                        <lido:appellationValue lido:label= "paikan tyyppi esim. katuosoite">
                                            <!--esim.katuosoite-->
                                        </lido:appellationValue>
                                    </lido:namePlaceSet>                                    
                                    <lido:gml><!--koordinaatit GML speksin mukaisesti pisteenä Point tai alueena Polygon -->
                                        <gml:Point>
                                            <gml:coordinates>
                                                <!--koordinaatit-->
                                            </gml:coordinates>
                                        </gml:Point>
                                    </lido:gml>
                                    <lido:partOfPlace>
                                        <lido:namePlaceSet>
                                            <lido:appellationValue lido:label= "paikan tyyppi esim. kaupunginosa">
                                                <!--esim. kaupunginosa-->
                                            </lido:appellationValue>
                                        </lido:namePlaceSet>
                                        <lido:partOfPlace>
                                            <lido:namePlaceSet>
                                                <lido:appellationValue lido:label= "paikan tyyppi esim. kunta/kaupunki">
                                                    <!--esim.kunta/kaupunki-->
                                                </lido:appellationValue>
                                            </lido:namePlaceSet>
                                            <lido:partOfPlace>
                                                <lido:namePlaceSet>
                                                    <lido:appellationValue lido:label= "paikan tyyppi esim. maa/valtio">
                                                        <!--esim. maa/valtio-->
                                                    </lido:appellationValue>
                                                </lido:namePlaceSet>
                                            </lido:partOfPlace>
                                        </lido:partOfPlace>
                                    </lido:partOfPlace>
                                   </lido:vitalPlaceActor>
                                  <lido:genderActor>valmistajan sukupuoli</lido:genderActor>       
                                 </lido:actor>
                                <lido:roleActor>
                                    <lido:term xml:lang="fi"><!--valmistajan rooli fi--></lido:term> 
                                    <lido:term xml:lang="en"><!--valmistajan rooli en--></lido:term>
                                    <lido:term xml:lang="sv"><!--valmistajan rooli sv--></lido:term>                                   
                                </lido:roleActor>
                                 <lido:sourceActorInRole>
                                <!--lähdetieto valmistajan roolista, jos mahdollista julkaistu lähde-->
                                </lido:sourceActorInRole>
                            </lido:actorInRole>
                        </lido:eventActor>
                            <!--valmistusajan kooste-->
                            <lido:eventDate>							
								<lido:displayDate xml:lang="fi">
									<!--valmistusaikakooste fi-->
								</lido:displayDate>	
								<lido:displayDate xml:lang="en">
									<!--valmistusaikakooste en-->
								</lido:displayDate>	
								<lido:displayDate xml:lang="sv">
									<!--valmistusaikakooste sv-->
								</lido:displayDate>
						    <lido:date>
                                <lido:earliestDate>
                                    <!--valmistuaika alku, ajat merkitään ISO 8601 standardin mukaisessa muodossa:YYYY tai YYYY-MM-DD-->
                                </lido:earliestDate>
                                <lido:latestDate>
                                    <!--valmistuaika loppu-->
                                </lido:latestDate>
                                <!--lido:earliestDate lido:type="arvio"-->
                                <!--valmistuaika alku-->
                                <!--/lido:earliestDate-->
                                <!--lido:latestDate  lido:type="arvio"-->
                                <!--valmistuaika loppu-->
                                <!--/lido:latestDate-->
                                <!--lido:earliestDate lido:source="lähde"-->
                                <!--valmistuaika alku lähde-->
                                <!--/lido:earliestDate-->
                                <!--lido:latestDate  lido:type="lähde"-->
                                <!--valmistuaika loppu lähde-->
                                <!--/lido:latestDate-->
                            </lido:date>
                        </lido:eventDate>
                        <lido:eventPlace>
                            <lido:displayPlace xml:lang="fi"><!--valmistuspaikan kooste fi--></lido:displayPlace>
                             <lido:displayPlace xml:lang="en"><!--valmistuspaikan kooste en--></lido:displayPlace>
                             <lido:displayPlace xml:lang="sv"><!--valmistuspaikan kooste sv--></lido:displayPlace>
                            <lido:place>
                              <!--valmistuspaikan YSO-URI -->
					           <lido:placeID lido:type="URI" lido:source="YSO">esim. http://www.yso.fi/onto/yso/p94415/</lido:placeID>
                                   <lido:namePlaceSet>
                                    <lido:appellationValue lido:label= "paikan tyyppi esim. katuosoite">
                                        <!--esim. katuosoite-->
                                    </lido:appellationValue>                                   
                                </lido:namePlaceSet>
                                <lido:gml><!--koordinaatit GML speksin mukaisesti pisteenä Point tai alueena Polygon -->
                                    <gml:Point>
                                        <gml:coordinates>
                                            <!--koordinaatit -->
                                        </gml:coordinates>
                                    </gml:Point>
                                </lido:gml>
                                <lido:partOfPlace>
                                    <lido:namePlaceSet>
                                        <lido:appellationValue lido:label= "paikan tyyppi esim. kaupunginosa">
                                            <!--esim. kaupunginosa-->
                                        </lido:appellationValue>                                        
                                    </lido:namePlaceSet>
                                    <lido:partOfPlace>
                                        <lido:namePlaceSet>
                                            <lido:appellationValue  lido:label= "paikan tyyppi esim. kunta/kaupunki">
                                                <!--esim. kunta/kaupunki-->
                                            </lido:appellationValue>                                            
                                        </lido:namePlaceSet>
                                        <lido:partOfPlace>
                                            <lido:namePlaceSet>
                                                <lido:appellationValue lido:label= "paikan tyyppi esim. maa/valtio">
                                                    <!--esim. maa/valtio-->
                                                </lido:appellationValue>                                                
                                            </lido:namePlaceSet>
                                        </lido:partOfPlace>
                                    </lido:partOfPlace>
                                </lido:partOfPlace>
                            </lido:place>
                        </lido:eventPlace>                        
                        <!--muinaisjäännös- ja rakennusperintörekisteritunnukset-->
                        <lido:eventPlace>	
                        <!--muinaisjäännös- tai rakennusperintörekisterikohde-->				       
								<lido:displayPlace><!--rekisterikohde esim. Lopen vanha kirkko--></lido:displayPlace>
								<lido:place>
								    <!--type-attribuuttiin laitetaan arvoksi joko "rpr", eli rakennusperintörekisteri tai "mjr", eli muinaisjäännösrekisteri--> 
							      	<lido:placeID lido:type="rpr"><!--esim. 200578--></lido:placeID>
                                    <lido:placeID lido:type="mjr"><!--esim. 1000027057--></lido:placeID>      							                      									
								</lido:place>	
						</lido:eventPlace>                       
                        <lido:eventMethod>
                            <!--valmistustapa tämä elementti kertautuu kutakin valmistustekniikkaa kohden-->
                            <lido:conceptID lido:type="URI">KOKO URI esim. http://www.yso.fi/onto/koko/p32546</lido:conceptID>
                            <lido:term xml:lang="fi"><!--valmistustapa fi esim. neulakinnastekniikka--></lido:term>
                            <lido:term xml:lang="en"><!--valmistustapa en esim. naalbinding technique--></lido:term>
                            <lido:term xml:lang="sv"><!--valmistustapa sv esim. nålbindningsteknik--></lido:term>
                        </lido:eventMethod>
                        <lido:eventMaterialsTech>                        
                            <!--valmistusmateriaali-->
                            <lido:displayMaterialsTech xml:lang="fi"><!--materiaalikooste fi--></lido:displayMaterialsTech>
                            <lido:displayMaterialsTech xml:lang="en"><!--materiaalikooste en--></lido:displayMaterialsTech>
                            <lido:displayMaterialsTech xml:lang="sv"><!--materiaalikooste sv--></lido:displayMaterialsTech>
                            <lido:materialsTech>                                 
                                <lido:termMaterialsTech>
                                    <!--tämä elementti kertautuu kutakin materiaalia kohden-->
                                    <lido:conceptID lido:type="URI">KOKO URI esim. https://finto.fi/koko/fi/page/p33150</lido:conceptID>
                                    <lido:term xml:lang="fi"><!--materiaali fi esim. villa--></lido:term>
                                    <lido:term xml:lang="en"><!--materiaali en esim. wool--></lido:term>
                                    <lido:term xml:lang="fi"><!--materiaali sv esim. ull--></lido:term>
                                </lido:termMaterialsTech>
                            </lido:materialsTech>
                        </lido:eventMaterialsTech>
                        <!--valmistukseen liittyvää lisätietoa -->
                        <lido:eventDescriptionSet>
								<lido:descriptiveNoteValue xml:lang="fi"><!--valmistuksen lisätiedot fi--></lido:descriptiveNoteValue>
								<lido:descriptiveNoteValue xml:lang="en"><!--valmistuksen lisätiedot en--></lido:descriptiveNoteValue>
								<lido:descriptiveNoteValue xml:lang="sv"><!--valmistuksen lisätiedot sv--></lido:descriptiveNoteValue>
						</lido:eventDescriptionSet>                        
                    </lido:event>
                </lido:eventSet>
                <lido:eventSet>
                    <lido:event>
                        <lido:eventType>
                            <!--käyttötiedot-->
                            <lido:term>käyttö</lido:term>
                        </lido:eventType>
                        <lido:eventActor>
                         <!--käyttöön liittyvä toimija, toista elementtiä, jos toimijoita on useita.-->
                            <lido:actorInRole>
                                <lido:actor>
                                    <lido:nameActorSet>
                                        <lido:appellationValue>
                                            <!--käyttäjän nimi-->
                                        </lido:appellationValue>
                                    </lido:nameActorSet>                                   
                                    <lido:nationalityActor>
                                          <lido:term><!--käyttäjän kansallisuus--></lido:term>
                                   </lido:nationalityActor>                           
                                   <lido:vitalDatesActor>
                                        <!--käyttäjän elinaika-->
                                        <lido:earliestDate lido:type="xxx">
                                            <!--käyttäjän syntymäaika/syntymävuosi-->
                                        </lido:earliestDate>
                                        <lido:latestDate lido:type="xxx">
                                            <!--käyttäjän kuolinaika/kuolinvuosi-->
                                        </lido:latestDate>
                                    </lido:vitalDatesActor>
                                   <lido:vitalPlaceActor lido:type="xxx">
                                   <!--käyttäjän syntymä-/kuolinpaikka tai toimintapaikka-->
                                       <lido:placeID lido:type="esim. URI">
                                       <!--paikan yksilöllinen tunniste-->
                                       </lido:placeID>
                                       <lido:namePlaceSet>
                                        <lido:appellationValue lido:label= "paikan tyyppi esim. katuosoite">
                                            <!--esim. katuosoite-->
                                        </lido:appellationValue>
                                    </lido:namePlaceSet>                                    
                                    <lido:gml><!--koordinaatit GML speksin mukaisesti pisteenä Point tai alueena Polygon -->
                                        <gml:Point>
                                            <gml:coordinates>
                                                <!--koordinaatit-->
                                            </gml:coordinates>
                                        </gml:Point>
                                    </lido:gml>
                                    <lido:partOfPlace>
                                        <lido:namePlaceSet>
                                            <lido:appellationValue lido:label= "paikan tyyppi esim. kaupunginosa">
                                                <!--esim. kaupunginosa-->
                                            </lido:appellationValue>
                                        </lido:namePlaceSet>
                                        <lido:partOfPlace>
                                            <lido:namePlaceSet>
                                                <lido:appellationValue lido:label= "paikan tyyppi esim. kunta/kaupunki">
                                                    <!--esim. kunta/kaupunki-->
                                                </lido:appellationValue>
                                            </lido:namePlaceSet>
                                            <lido:partOfPlace>
                                                <lido:namePlaceSet>
                                                    <lido:appellationValue lido:label= "paikan tyyppi esim. maa/valtio">
                                                        <!--esim. maa/valtio-->
                                                    </lido:appellationValue>
                                                </lido:namePlaceSet>
                                            </lido:partOfPlace>
                                        </lido:partOfPlace>
                                    </lido:partOfPlace>
                                   </lido:vitalPlaceActor>
                                  <lido:genderActor>käyttäjän sukupuoli</lido:genderActor>                     
                                </lido:actor>
                                <lido:roleActor>
                                    <!--vakiotermi käyttäjä-->
                                    <lido:term>käyttäjä</lido:term>
                                </lido:roleActor>
                                  <lido:sourceActorInRole>
                                <!--lähdetieto käyttäjän roolista, jos mahdollista julkaistu lähde-->
                                </lido:sourceActorInRole>
                            </lido:actorInRole>
                        </lido:eventActor>      
                            <!--käyttöaikakooste -->
                            <lido:eventDate>							
								<lido:displayDate xml:lang="fi">
									<!--käyttöaikakooste fi-->
								</lido:displayDate>	
								<lido:displayDate xml:lang="en">
									<!--käyttöaikakooste en-->
								</lido:displayDate>	
								<lido:displayDate xml:lang="sv">
									<!--käyttöaikakooste sv-->
								</lido:displayDate>
                              <lido:date>
                                <lido:earliestDate>
                                    <!--käyttöaika-alku-->
                                </lido:earliestDate>
                                <lido:latestDate>
                                    <!--käyttöaikaloppu-->
                                </lido:latestDate>
                            </lido:date>
                        </lido:eventDate>
                        <lido:eventPlace>
                            <lido:displayPlace xml:lang="fi"><!--käyttöpaikan kooste fi--></lido:displayPlace>                                
                            <lido:displayPlace xml:lang="en"><!--käyttöpaikan kooste en--></lido:displayPlace>
                             <lido:displayPlace xml:lang="sv"><!--käyttöpaikan kooste sv--></lido:displayPlace>
                            <lido:place>
                                <!--käyttöpaikan YSO-URI -->
					           <lido:placeID lido:type="URI" lido:source="YSO">esim. http://www.yso.fi/onto/yso/p94415/</lido:placeID>
                                <lido:namePlaceSet>
                                    <lido:appellationValue lido:label= "paikan tyyppi esim.katuosoite">
                                        <!--esim. katuosoite-->
                                    </lido:appellationValue>
                                </lido:namePlaceSet>
                                <lido:gml><!--koordinaatit GML-speksin mukaisesti pisteenä Point tai alueena Polygon -->
                                    <gml:Point>
                                        <gml:coordinates>
                                            <!--koordinaatit-->
                                        </gml:coordinates>
                                    </gml:Point>
                                </lido:gml>
                                <lido:partOfPlace>
                                    <lido:namePlaceSet>
                                        <lido:appellationValue lido:label= "paikan tyyppi esim. kaupunginosa">
                                            <!--esim kaupunginosa-->
                                        </lido:appellationValue>
                                    </lido:namePlaceSet>
                                    <lido:partOfPlace>
                                        <lido:namePlaceSet>
                                            <lido:appellationValue lido:label= "paikan tyyppi esim. kunta/kaupunki">
                                                <!--esim. kunta/kaupunki-->
                                            </lido:appellationValue>
                                        </lido:namePlaceSet>
                                        <lido:partOfPlace>
                                            <lido:namePlaceSet>
                                                <lido:appellationValue lido:label= "paikan tyyppi esim. maa/valtio">
                                                    <!--esim. maa/valtio-->
                                                </lido:appellationValue>
                                            </lido:namePlaceSet>
                                        </lido:partOfPlace>
                                    </lido:partOfPlace>
                                </lido:partOfPlace>
                            </lido:place>
                        </lido:eventPlace>
                        <!--muinaisjäännös- ja rakennusperintörekisteritunnukset-->
                        <lido:eventPlace>	
                        <!--muinaisjäännös- tai rakennusperintörekisterikohde-->				       
								<lido:displayPlace><!--rekisterikohde esim. Lopen vanha kirkko--></lido:displayPlace>
								<lido:place>
								    <!--type-attribuuttiin laitetaan arvoksi joko "rpr", eli rakennusperintörekisteri tai "mjr", eli muinaisjäännösrekisteri--> 
							      	<lido:placeID lido:type="rpr"><!--esim. 200578--></lido:placeID>
                                    <lido:placeID lido:type="mjr"><!--esim. 1000027057--></lido:placeID>									      							                      									
								</lido:place>	
						</lido:eventPlace>  
                        <lido:eventDescriptionSet>
                            <lido:descriptiveNoteValue>
                                <!--käytön kuvaus, mm. käyttötarkoitus, käyttötapa-->
                            </lido:descriptiveNoteValue>
                        </lido:eventDescriptionSet>
                    </lido:event>
                </lido:eventSet>               
               <lido:eventSet>
                    <lido:event>
                        <lido:eventType>
                            <!--löytötiedot-->
                            <lido:term xml:lang="fi">löytyminen</lido:term>
                       	    <lido:term xml:lang="en">finding</lido:term>
                        </lido:eventType>
                        <lido:eventActor>
                         <!--löytämiseen liittyvä toimija, toista elementtiä, jos toimijoita on useita.-->
                            <lido:actorInRole>
                                <lido:actor>
                                    <lido:nameActorSet>
                                        <lido:appellationValue>
                                            <!--löytäjän nimi-->
                                        </lido:appellationValue>
                                    </lido:nameActorSet>                                   
                                    <lido:nationalityActor>
                                          <lido:term><!--löytäjän kansallisuus--></lido:term>
                                   </lido:nationalityActor>                           
                                   <lido:vitalDatesActor>
                                        <!--löytäjän elinaika-->
                                        <lido:earliestDate lido:type="xxx">
                                            <!--löytäjän syntymäaika/syntymävuosi-->
                                        </lido:earliestDate>
                                        <lido:latestDate lido:type="xxx">
                                            <!--löytäjän kuolinaika/kuolinvuosi-->
                                        </lido:latestDate>
                                    </lido:vitalDatesActor>
                                   <lido:vitalPlaceActor lido:type="xxx">
                                   <!--löytäjän syntymä-/kuolinpaikka tai toimintapaikka-->
                                       <lido:placeID lido:type="esim. URI">
                                       <!--paikan yksilöllinen tunniste-->
                                       </lido:placeID>
                                       <lido:namePlaceSet>
                                        <lido:appellationValue lido:label= "paikan tyyppi esim. katuosoite">
                                            <!--esim. katuosoite-->
                                        </lido:appellationValue>
                                    </lido:namePlaceSet>                                    
                                    <lido:gml><!--koordinaatit GML speksin mukaisesti pisteenä Point tai alueena Polygon -->
                                        <gml:Point>
                                            <gml:coordinates>
                                                <!--koordinaatit-->
                                            </gml:coordinates>
                                        </gml:Point>
                                    </lido:gml>
                                    <lido:partOfPlace>
                                        <lido:namePlaceSet>
                                            <lido:appellationValue lido:label= "paikan tyyppi esim. kaupunginosa">
                                                <!--esim. kaupunginosa-->
                                            </lido:appellationValue>
                                        </lido:namePlaceSet>
                                        <lido:partOfPlace>
                                            <lido:namePlaceSet>
                                                <lido:appellationValue lido:label= "paikan tyyppi esim. kunta/kaupunki">
                                                    <!--esim. kunta/kaupunki-->
                                                </lido:appellationValue>
                                            </lido:namePlaceSet>
                                            <lido:partOfPlace>
                                                <lido:namePlaceSet>
                                                    <lido:appellationValue lido:label= "paikan tyyppi esim. maa/valtio">
                                                        <!--esim. maa/valtio-->
                                                    </lido:appellationValue>
                                                </lido:namePlaceSet>
                                            </lido:partOfPlace>
                                        </lido:partOfPlace>
                                    </lido:partOfPlace>
                                   </lido:vitalPlaceActor>
                                  <lido:genderActor>löytäjän sukupuoli</lido:genderActor>                     
                                </lido:actor>
                                <lido:roleActor>
                                     <lido:term>löytäjä</lido:term>
                                </lido:roleActor>
                                  <lido:sourceActorInRole>
                                <!--lähdetieto löytäjän roolista, jos mahdollista julkaistu lähde-->
                                </lido:sourceActorInRole>
                            </lido:actorInRole>
                        </lido:eventActor>
                        <lido:eventDate>
                            <!--löytöaikakooste-->
                         		<lido:displayDate xml:lang="fi">
									<!--löytöaikakooste fi-->
								</lido:displayDate>	
								<lido:displayDate xml:lang="en">
									<!--löytöaikakooste en-->
								</lido:displayDate>	
								<lido:displayDate xml:lang="sv">
									<!--löytöaikakooste sv-->
								</lido:displayDate>
                            <lido:date>
                                <lido:earliestDate>
                                    <!--löytöaika-alku-->
                                </lido:earliestDate>
                                <lido:latestDate>
                                    <!--löytöaikaloppu-->
                                </lido:latestDate>
                            </lido:date>
                        </lido:eventDate>
                        <lido:eventPlace>
                            <lido:displayPlace xml:lang="fi"><!--löytöpaikan kooste fi--></lido:displayPlace>
                            <lido:displayPlace xml:lang="en"><!--löytöpaikan kooste en--></lido:displayPlace>
                            <lido:displayPlace xml:lang="sv"><!--löytöpaikan kooste sv--></lido:displayPlace>
                            <lido:place>
                                <!--löytöpaikan YSO-URI -->
					           <lido:placeID lido:type="URI" lido:source="YSO">esim. http://www.yso.fi/onto/yso/p94415/</lido:placeID>
                                <lido:namePlaceSet>
                                    <lido:appellationValue lido:label= "paikan tyyppi esim.katuosoite">
                                        <!--esim. katuosoite-->
                                    </lido:appellationValue>
                                </lido:namePlaceSet>
                                <lido:gml><!--koordinaatit GML-speksin mukaisesti pisteenä Point tai alueena Polygon -->
                                    <gml:Point>
                                        <gml:coordinates>
                                            <!--koordinaatit-->
                                        </gml:coordinates>
                                    </gml:Point>
                                </lido:gml>
                                <lido:partOfPlace>
                                    <lido:namePlaceSet>
                                        <lido:appellationValue lido:label= "paikan tyyppi esim. kaupunginosa">
                                            <!--esim kaupunginosa-->
                                        </lido:appellationValue>
                                    </lido:namePlaceSet>
                                    <lido:partOfPlace>
                                        <lido:namePlaceSet>
                                            <lido:appellationValue lido:label= "paikan tyyppi esim. kunta/kaupunki">
                                                <!--esim. kunta/kaupunki-->
                                            </lido:appellationValue>
                                        </lido:namePlaceSet>
                                        <lido:partOfPlace>
                                            <lido:namePlaceSet>
                                                <lido:appellationValue lido:label= "paikan tyyppi esim. maa/valtio">
                                                    <!--esim. maa/valtio-->
                                                </lido:appellationValue>
                                            </lido:namePlaceSet>
                                        </lido:partOfPlace>
                                    </lido:partOfPlace>
                                </lido:partOfPlace>
                            </lido:place>
                        </lido:eventPlace>
                        <!--muinaisjäännös- ja rakennusperintörekisteritunnukset-->
                        <lido:eventPlace>	
                        <!--muinaisjäännös- tai rakennusperintörekisterikohde-->				       
								<lido:displayPlace><!--rekisterikohde esim. Lopen vanha kirkko--></lido:displayPlace>
								<lido:place>
								    <!--type-attribuuttiin laitetaan arvoksi joko "rpr", eli rakennusperintörekisteri tai "mjr", eli muinaisjäännösrekisteri--> 
							      	<lido:placeID lido:type="rpr"><!--esim. 200578--></lido:placeID>
                                    <lido:placeID lido:type="mjr"><!--esim. 1000027057--></lido:placeID>									      							                      									
								</lido:place>	
						</lido:eventPlace>  
                    </lido:event>
                </lido:eventSet>                
                <lido:eventSet>
                    <lido:event>
                        <lido:eventType>
                            <lido:term>näyttely</lido:term>
                        </lido:eventType>
                        <lido:eventName>
                            <lido:appellationValue>
                                <!--näyttelyn nimi-->
                            </lido:appellationValue>
                        </lido:eventName>
                        <lido:eventDate>
                            <lido:displayDate>
                                <!--näyttelyn aika-->
                            </lido:displayDate>
                            <lido:date>
                                <lido:earliestDate>
                                    <!--näyttelyalkupvm-->
                                </lido:earliestDate>
                                <lido:latestDate>
                                    <!--näyttelyloppupvm-->
                                </lido:latestDate>
                            </lido:date>
                        </lido:eventDate>
                        <lido:eventPlace>
                            <lido:displayPlace>
                                <!--näyttelypaikka"-->
                            </lido:displayPlace>
                        </lido:eventPlace>
                    </lido:event>
                </lido:eventSet>
            </lido:eventWrap>
            <lido:objectRelationWrap>
                <lido:subjectWrap>
                    <lido:subjectSet>
                        <!--aiheeseen liittyvää tietoa mm. aihe/nimi, aiheen toimija, aiheen paikat-->
                        <lido:displaySubject>
                            <!--aihe/nimi-->
                        </lido:displaySubject>
                        <lido:subject>
                            <!--kontrolloiduista sanastoista otetuilla termeillä tulisi olla URI-->
                            <lido:subjectActor>
                             <!--aiheeseen liittyvä toimija, toista elementtiä, jos toimijoita on useita.-->
                                <lido:actor>
                                    <lido:nameActorSet>
                                        <lido:appellationValue>
                                            <!--aiheen toimija-->
                                        </lido:appellationValue>
                                    </lido:nameActorSet> 
                                   <lido:nationalityActor>
                                          <lido:term><!--aiheen toimijan kansallisuus--></lido:term>
                                   </lido:nationalityActor>                           
                                   <lido:vitalDatesActor>
                                        <!--aiheen toimijan elinaika-->
                                        <lido:earliestDate lido:type="xxx">
                                            <!--aiheen toimijan syntymäaika/syntymävuosi-->
                                        </lido:earliestDate>
                                        <lido:latestDate lido:type="xxx">
                                            <!--aiheen toimijan kuolinaika/kuolinvuosi-->
                                        </lido:latestDate>
                                    </lido:vitalDatesActor>
                                   <lido:vitalPlaceActor lido:type="xxx">
                                   <!--aiheen toimijan syntymä-/kuolinpaikka tai toimintapaikka-->
                                       <lido:placeID lido:type="esim. URI">
                                       <!--paikan yksilöllinen tunniste-->
                                       </lido:placeID>
                                       <lido:namePlaceSet>
                                        <lido:appellationValue lido:label= "paikan tyyppi esim. katuosoite">
                                            <!--esim.katuosoite-->
                                        </lido:appellationValue>
                                    </lido:namePlaceSet>                                    
                                    <lido:gml><!--koordinaatit GML speksin mukaisesti pisteenä Point tai alueena Polygon -->
                                        <gml:Point>
                                            <gml:coordinates>
                                                <!--koordinaatit-->
                                            </gml:coordinates>
                                        </gml:Point>
                                    </lido:gml>
                                    <lido:partOfPlace>
                                        <lido:namePlaceSet>
                                            <lido:appellationValue lido:label= "paikan tyyppi esim. kaupunginosa">
                                                <!--esim. kaupunginosa-->
                                            </lido:appellationValue>
                                        </lido:namePlaceSet>
                                        <lido:partOfPlace>
                                            <lido:namePlaceSet>
                                                <lido:appellationValue lido:label= "paikan tyyppi esim. kunta/kaupunki">
                                                    <!--esim. kunta/kaupunki-->
                                                </lido:appellationValue>
                                            </lido:namePlaceSet>
                                            <lido:partOfPlace>
                                                <lido:namePlaceSet>
                                                    <lido:appellationValue lido:label= "paikan tyyppi esim. maa/valtio">
                                                        <!--esim. maa/valtio-->
                                                    </lido:appellationValue>
                                                </lido:namePlaceSet>
                                            </lido:partOfPlace>
                                        </lido:partOfPlace>
                                    </lido:partOfPlace>
                                   </lido:vitalPlaceActor>
                                  <lido:genderActor>aiheen toimijan sukupuoli</lido:genderActor>
                                </lido:actor>
                            </lido:subjectActor>
                            <lido:subjectDate>
                                <!--aiheen aikakooste-->
                                <lido:displayDate xml:lang="fi">
                                   <!--aiheen aikakooste fi-->
                                </lido:displayDate>
                                <lido:displayDate xml:lang="en">
                                   <!--aiheen aikakooste en-->
                                </lido:displayDate>
                                <lido:displayDate xml:lang="sv">
                                   <!--aiheen aikakooste sv-->
                                </lido:displayDate>
                                <lido:date>
                                    <lido:earliestDate>
                                        <!--aiheen alkuvuosi-->
                                    </lido:earliestDate>
                                    <lido:latestDate>
                                        <!--aiheen loppuvuosi-->
                                    </lido:latestDate>
                                </lido:date>
                            </lido:subjectDate>
                            <lido:subjectPlace>
                                <lido:displayPlace xml:lang="fi"><!--aiheenpaikan kooste fi--></lido:displayPlace>
                                <lido:displayPlace xml:lang="en"><!--aiheenpaikan kooste en--></lido:displayPlace>
                                <lido:displayPlace xml:lang="sv"><!--aiheenpaikan kooste sv--></lido:displayPlace>
                                <lido:place>
                                    <!--aiheenpaikan YSO-URI -->
					           <lido:placeID lido:type="URI" lido:source="YSO">esim. http://www.yso.fi/onto/yso/p94415/</lido:placeID>
                                    <lido:namePlaceSet>
                                        <lido:appellationValue lido:label= "paikan tyyppi esim. katuosoite">
                                            <!--esim. katuosoite-->
                                        </lido:appellationValue>
                                    </lido:namePlaceSet>                                    
                                    <lido:gml><!--koordinaatit GML speksin mukaisesti pisteenä Point tai alueena Polygon -->
                                        <gml:Point>
                                            <gml:coordinates>
                                                <!--koordinaatit-->
                                            </gml:coordinates>
                                        </gml:Point>
                                    </lido:gml>
                                    <lido:partOfPlace>
                                        <lido:namePlaceSet>
                                            <lido:appellationValue lido:label= "paikan tyyppi esim. kaupunginosa">
                                                <!--esim. kaupunginosa-->
                                            </lido:appellationValue>
                                        </lido:namePlaceSet>
                                        <lido:partOfPlace>
                                            <lido:namePlaceSet>
                                                <lido:appellationValue lido:label= "esim. kunta/kaupunki">
                                                    <!--esim. kunta/kaupunki-->
                                                </lido:appellationValue>
                                            </lido:namePlaceSet>
                                            <lido:partOfPlace>
                                                <lido:namePlaceSet>
                                                    <lido:appellationValue lido:label= "paikan tyyppi esim. maa/valtio">
                                                        <!--esim. maa/valtio-->
                                                    </lido:appellationValue>
                                                </lido:namePlaceSet>
                                            </lido:partOfPlace>
                                        </lido:partOfPlace>
                                    </lido:partOfPlace>
                                </lido:place>
                            </lido:subjectPlace>
                            <!--muinaisjäännös- ja rakennusperintörekisteritunnukset-->
                            <lido:subjectPlace>	
                                <!--muinaisjäännös- tai rakennusperintörekisterikohde-->				       
								<lido:displayPlace><!--rekisterikohde esim. Lopen vanha kirkko--></lido:displayPlace>
								<lido:place>
								    <!--type-attribuuttiin laitetaan arvoksi joko "rpr", eli rakennusperintörekisteri tai "mjr", eli muinaisjäännösrekisteri--> 
							      	<lido:placeID lido:type="rpr"><!--esim. 200578--></lido:placeID>
                                    <lido:placeID lido:type="mjr"><!--esim. 1000027057--></lido:placeID>									      							                      									
								</lido:place>	
						   </lido:subjectPlace>  
                        </lido:subject>
                    </lido:subjectSet>
                    <lido:subjectSet>
                        <lido:subject>
                            <!--asiasanat-->
                            <lido:subjectConcept>
                                <lido:conceptID lido:source="1. asiasanan sanaston nimi" lido:type="URI"><!--1. asiasanan URI--></lido:conceptID>
                                <lido:term lido:label="asiasana" xml:lang="fi"><!--asiasanan termi--></lido:term>
                                <lido:term lido:label="asiasana" xml:lang="en"><!--asiasanan termi--></lido:term>
                                <lido:term lido:label="asiasana" xml:lang="sv"><!--asiasanan termi--></lido:term>
                            </lido:subjectConcept>
                           <lido:subjectConcept>
                                <lido:conceptID lido:source="2. asiasanan sanaston nimi" lido:type="URI"><!--2. asiasanan URI--></lido:conceptID>
                                <lido:term lido:label="asiasana" xml:lang="fi">><!--asiasanan termi--></lido:term>
                                <lido:term lido:label="asiasana" xml:lang="en"><!--asiasanan termi--></lido:term>
                                <lido:term lido:label="asiasana" xml:lang="sv"><!--asiasanan termi--></lido:term>
                            </lido:subjectConcept>
                        </lido:subject>
                    </lido:subjectSet>
                </lido:subjectWrap>
                <lido:relatedWorksWrap>
                <!--Tässä kohdassa viitataan objektiin liittyviin muihin aineistoihin esim. kokoelmiin, julkaisuihin, sarjoihin ja ryhmiin. Kohteen objectID -tunnisteen, esim URI, ISBN, avulla voidaan tehdä linkityksiä aineistojen välille.-->                                
                    <lido:relatedWorkSet>
                    <lido:displayRelatedWork>
                    <!--kooste: objektiin liittyvän aineiston kuvaus, liittyvän aineiston tunniste ja suhde alkuperäiseen objektiin esim. julkaisun nimi ja sen objectID -->    
                     </lido:displayRelatedWork>
                        <lido:relatedWork>
                        <!--aineistokokonaisuus, johon objekti sisältyy-->
                            <lido:displayObject xml:lang="fi">
                                <!--aineistokokonaisuuden nimi esim. JOKA Journalistinen kuva-arkisto--></lido:displayObject>
                             <lido:displayObject xml:lang="en">
                                <!--aineistokokonaisuuden nimi esim. Press Photo Archive JOKA--></lido:displayObject>
                             <lido:displayObject xml:lang="sv">
                                <!--aineistokokonaisuuden nimi esim. Journalistiska bildarkivet JOKA--></lido:displayObject>
                        </lido:relatedWork>
                        <lido:relatedWorkRelType>
                            <lido:term><!--kokonaisuuden tyyppi, esim. arkisto, kokoelma, alakokoelma, erityiskokoelma, hankintaerä tms.--></lido:term>                           
                        </lido:relatedWorkRelType>
                    </lido:relatedWorkSet>                                       
                   <!--Aineistohierarkiaa kuvaavat relatedWorkSetit alkaa-->
                   <!-- hierarkia asiakaswikissä https://www.kiwi.fi/pages/viewpage.action?pageId=322011180--> 
                   <!--HUOM. Jos haluat tuoda hierarkkisen aineistokokonaisuuden Finnaan, ota yhteyttä finna-posti@helsinki.fi-->                                
                    <lido:relatedWorkSet>
                        <lido:relatedWork> 
                             <!--hierarkian ylin taso collection, kussakin tietueessa voi olla viittaus VAIN YHTEEN collection-tasoon-->                
                            <!--sen tietueen taustajärjestelmässä oleva identifioiva tunniste ja nimi, johon tässä relatedWorkSetissä viitataan-->
                            <lido:displayObject><!--esim. JOKAEES, Eero Saurin kokoelma--></lido:displayObject>         
                              <lido:object>
                                       <lido:objectWebResource></lido:objectWebResource>
                                      <!--sen tietueen  lidoRecID-tunniste, johon tässä relatedWorkSetissä viitataan-->
                                      <lido:objectID lido:type="local identifier"><!--esim. cc9fb1c2-5915-4fa2-b47f-95d7f175ece3--></lido:objectID>                                     
                                      <lido:objectType>  
                                               <lido:conceptID lido:type="URI">http://terminology.lido-schema.org/lido01053</lido:conceptID> 
                                               <lido:term>collection</lido:term>                                  
                                          </lido:objectType>                                                 
                                      <!--sen tietueen aineistotyyppi, johon tässä relatedWorkSetissä viitataan esim sarja, kokoelma-->
                                      <lido:objectNote lido:type="objectWorkType"><!--esim. Kokoelma--></lido:objectNote>
                               </lido:object>
                         </lido:relatedWork>
                         <lido:relatedWorkRelType> 
                             <lido:conceptID lido:type=""></lido:conceptID>
                             <!--arvon tulee olla hierarkkisella aineistolla 'is part of' erotuksena ei-hierarkkisesta aineistosta,-->                          
                            <lido:term>is part of</lido:term>
                         </lido:relatedWorkRelType>                         
                    </lido:relatedWorkSet>                  
					<lido:relatedWorkSet>
						<lido:relatedWork>
						          <!--parent-viittaus VAIN lähivanhempaan/lähivanhempiin (jos kuuluu useampiin)-->				              
					              <!--sen tietueen taustajärjestelmässä oleva identifioiva tunniste ja nimi, johon tässä relatedWorkSetissä viitataan-->				
							       <lido:displayObject><!--esim. JOKAEES10_08:-, Luojan armeliaita päiviä Heinolan hiekkarannalla--></lido:displayObject >									
								   <lido:object>								          
                                           <lido:objectWebResource></lido:objectWebResource>
                                            <!--sen tietueen  lidoRecID-tunniste, johon tässä relatedWorkSetissä viitataan-->
                                            <lido:objectID lido:type="local identifier"><!--esim. 7886c89d-8ded-4478-b856-1951c8d19179--></lido:objectID>                                            	
                                             <lido:objectType>
                                                     <lido:conceptID lido:type="URI"></lido:conceptID> 
                                                      <lido:term>parent</lido:term>  
                                             </lido:objectType>		    
											<!--sen tietueen aineistotyyppi, johon tässä relatedWorkSetissä viitataan esim sarja, kokoelma-->
                                            <lido:objectNote lido:type="objectWorkType"><!--esim. Sarja--></lido:objectNote>
                                    </lido:object>
                      	</lido:relatedWork>
							<lido:relatedWorkRelType>	
							      <lido:conceptID lido:type=""></lido:conceptID>						     
							     <!--arvon tulee olla hierarkkisella aineistolla 'is part of', jolla erottuu ei-hierarkkisesta aineistosta-->
								 <lido:term>is part of</lido:term>
							</lido:relatedWorkRelType>							 
						</lido:relatedWorkSet>																								
					<!--Aineistohierarkiaa kuvaavat relatedWorkSetit päättyy-->					
                    <!--Muita aineistoyhteyksiä kuvaavat relatedWorkSetit alkaa-->                   
                    <lido:relatedWorkSet>
                        <lido:relatedWork>
                            <!--objektiin liittyvä julkaisu, esim lähdeteos tai näyttelyjulkaisu-->
                            <lido:displayObject lido:label="julkaistu teoksessa" xml:lang="fi"><!--julkaisun nimi fi--></lido:displayObject>
                            <lido:displayObject lido:label="published in" xml:lang="en"><!--julkaisun nimi en--></lido:displayObject>
                            <lido:displayObject lido:label="publicerad i" xml:lang="sv"><!--julkaisun nimi sv--></lido:displayObject>
                             <lido:object>
                             <lido:objectWebResource>
                                <!--linkki julkaisuun-->
                                </lido:objectWebResource>
                                <!--julkaisun identifioivat tiedot esim. ISBN-->
                                <lido:objectID lido:type="URI"><!--esim. URN:ISBN:978-951-851-628-9--></lido:objectID>
                             </lido:object>    
                        </lido:relatedWork>
                        <lido:relatedWorkRelType>
                            <!--relaation tyyppi eli miten julkaisu liittyy objektiin esim. lähdeteos, näyttelyjulkaisu, julkaisu-->
                            <lido:term><!--esim. julkaisu--></lido:term>
                        </lido:relatedWorkRelType>
                    </lido:relatedWorkSet>                    
                    <!--muinaisjäännös- tai rakennusperintörekisterikohde ja linkki -->
						<lido:relatedWorkSet>					
							 <lido:relatedWork>	
							       <!--muinaisjäännös- tai rakennusperintörekisterikohde-->						       
							       <lido:displayObject lido:label="kohde"><!--esim. Lopen vanha kirkko--></lido:displayObject>
							       <lido:object>
							          <!--muinaisjäännös- tai rakennusperintörekisterikohteen linkki-->
							          <lido:objectWebResource><!--esim. https://www.kyppi.fi/to.aspx?id=112.1000027057--></lido:objectWebResource>						  
							       </lido:object> 
							 </lido:relatedWork>
                             <lido:relatedWorkRelType>
									<lido:term>paikka</lido:term>
							 </lido:relatedWorkRelType>							 	                               
                        </lido:relatedWorkSet>
                </lido:relatedWorksWrap>                
            </lido:objectRelationWrap>
        </lido:descriptiveMetadata>
        <lido:administrativeMetadata xml:lang="fi">
            <lido:rightsWorkWrap>
            <!--kuvailun kohteena olevaa objektia, esim taideteosta, koskevat oikeudet-->
                <lido:rightsWorkSet> 
                <!--ilmaise vain yksi oikeus yhdessä rightsWorkSetissä-->
                    <lido:rightsType>
                    <lido:term><!-- oikeuden tyyppi, esim tekijänoikeus, käyttöoikeus.--></lido:term>
                    </lido:rightsType>
                    <lido:rightsHolder>
                        <lido:legalBodyName>
                            <lido:appellationValue><!-- oikeudenhaltijan nimi --></lido:appellationValue>
                        </lido:legalBodyName>
                    </lido:rightsHolder>
                    <lido:creditLine/>
                </lido:rightsWorkSet>
            </lido:rightsWorkWrap>
            <lido:recordWrap>
                <!--objektin identifioiva tieto, tietueen id tietokannasta-->
                <lido:recordID lido:type="local">
                    <!--Objektin aineistontarjoajan taustajärjestelmässä identifioiva tunniste. Tyyppeja "local" lisäksi voi olla esim. "doi" (Digital Objects Identifier) "localpermalinkpurl" (Persistent Uniform Resource Locator) "url" (Uniform Resource Locator)"urn" (Uniform Resource Name) "guid" (Globally unique identifier) "hdl" (Handle) "isbn" (International Standard Book Number) "ismn" (International Standard Music Number) "isrc" (International Standard Recording Code) "issn" (International Standard Serials Number)-->
                </lido:recordID>
                <lido:recordType>
                    <!--'collection', tai 'item', riippuen mitä hierarkian tasoa kuvataan. Hierarkiassa voi olla vain yksi collection-taso, jonka tietueelle otetaan käyttöön kokoelmasivupohja. -->
                    <lido:term>item tai collection</lido:term>
                </lido:recordType>
                <lido:recordSource>
                    <lido:legalBodyName>
                        <lido:appellationValue>
                            <!--objektin metadatan lähdeorganisaation nimi-->
                        </lido:appellationValue>
                    </lido:legalBodyName>
                    <lido:legalBodyWeblink>
                        <!--http://www.lähdeorganisaation osoite.fi-->
                    </lido:legalBodyWeblink>
                </lido:recordSource>
                <lido:recordRights>
                    <lido:rightsType>
                        <lido:conceptID lido:type="copyright">
                            <!--metadatan CC-lisenssi Finnan palvelusopimuksen mukaan CCO-->
                        </lido:conceptID>
                        <lido:term>
                            <!--metadatan CC-lisenssiä koskeva selkokielinen käyttöoikeusteksti, vapaaehtoinen-->
                        </lido:term>
                    </lido:rightsType>                        
                    <lido:rightsHolder><!--objektin metadatan oikeuden haltija, organisaatio-->
                        <lido:legalBodyName>
                            <lido:appellationValue>
                            <!--metadatan oikeudenhaltija esim. museo-->
                            </lido:appellationValue>
                        </lido:legalBodyName>
                        <lido:legalBodyWeblink>
                            <!--http://www.metadatanoikeudenhaltijan osoite.fi-->
                        </lido:legalBodyWeblink>
                    </lido:rightsHolder>
                </lido:recordRights>
                <!--Finnan vanha tunniste luokkahuonetta yms varten, poimitaan Finnassa kenttään 'ctrlnum' -->
				<lido:recordInfoSet>
							<lido:recordInfoID lido:type="old item"><!--esim. va1234--></lido:recordInfoID>
				</lido:recordInfoSet>
            </lido:recordWrap>
            <lido:resourceWrap>       
                     <!--Objektista tietueessa tarjottavat tiedostot. Saman tiedoston erikokoiset versiot merkitään yhteen resourceSet:iin alla olevan esimerkin mukaisesti.-->
                   <lido:resourceSet>					
                   <!--Yksilöllinen ID, jolla korkearesoluutio ja näyttökuva voidaan yhdistää toisiinsa-->		
                   <lido:resourceID lido:type="ID"><!--tiedoston ID kokoelmanhallintajärjestelmässä--></lido:resourceID> 			 		  
                   <lido:resourceRepresentation lido:type="image_thumb">
                        <!--pieni näyttökuva: näytetään hakutuloksessa, ei tarjota ladattavaksi-->
                        <lido:linkResource>
                            <!--tiedoston linkki-->
                        </lido:linkResource>                         
                            <lido:resourceMeasurementsSet>
                            <lido:measurementType xml:lang="fi">koko</lido:measurementType>
                            <lido:measurementType xml:lang="en">size</lido:measurementType>
                            <lido:measurementUnit>
                                <!--tiedoston yksikkö, esim. bytes-->
                            </lido:measurementUnit>
                            <lido:measurementValue>
                                <!--tiedoston koko tavuina-->
                            </lido:measurementValue>
                        </lido:resourceMeasurementsSet>
                        <lido:resourceMeasurementsSet>
                            <lido:measurementType xml:lang="fi">leveys</lido:measurementType>
                            <lido:measurementType xml:lang="en">width</lido:measurementType>
                            <lido:measurementUnit>
                                <!--tiedoston yksikkö, esim pixel, cm, mm-->
                            </lido:measurementUnit>
                            <lido:measurementValue>
                                <!--tiedoston leveys pikseleinä-->
                            </lido:measurementValue>
                        </lido:resourceMeasurementsSet>
                        <lido:resourceMeasurementsSet>
                            <lido:measurementType xml:lang="fi">korkeus</lido:measurementType>
                            <lido:measurementType xml:lang="en">height</lido:measurementType>
                            <lido:measurementUnit>
                                <!--tiedoston yksikkö, esim pixel, cm, mm-->
                            </lido:measurementUnit>
                            <lido:measurementValue>
                                <!--tiedoston korkeus pikseleinä-->
                            </lido:measurementValue>
                        </lido:resourceMeasurementsSet>
                    </lido:resourceRepresentation>                       
                    <lido:resourceRepresentation lido:type="image_large">
                        <!--iso (esim. 1200x1200px) jpg näyttökuva: näytetään käyttöliittymässä.-->
                        <lido:linkResource>
                            <!--tiedoston linkki-->
                        </lido:linkResource>
                        <lido:resourceMeasurementsSet>
                            <lido:measurementType xml:lang="fi">koko</lido:measurementType>
                            <lido:measurementType xml:lang="en">size</lido:measurementType>
                            <lido:measurementUnit>
                                <!--tiedoston yksikkö, esim. bytes-->
                            </lido:measurementUnit>
                            <lido:measurementValue>
                                <!--tiedoston koko tavuina-->
                            </lido:measurementValue>
                        </lido:resourceMeasurementsSet>
                        <lido:resourceMeasurementsSet>
                            <lido:measurementType xml:lang="fi">leveys</lido:measurementType>
                            <lido:measurementType xml:lang="en">width</lido:measurementType>
                            <lido:measurementUnit>
                                <!--tiedoston yksikkö, esim pixel, cm, mm-->
                            </lido:measurementUnit>
                            <lido:measurementValue>
                                <!--tiedoston leveys pikseleinä-->
                            </lido:measurementValue>
                        </lido:resourceMeasurementsSet>
                        <lido:resourceMeasurementsSet>
                            <lido:measurementType xml:lang="fi">korkeus</lido:measurementType>
                            <lido:measurementType xml:lang="en">height</lido:measurementType>
                            <lido:measurementUnit>
                                <!--tiedoston yksikkö, esim pixel, cm, mm-->
                            </lido:measurementUnit>
                            <lido:measurementValue>
                                <!--tiedoston korkeus pikseleinä-->
                            </lido:measurementValue>
                        </lido:resourceMeasurementsSet>
                    </lido:resourceRepresentation>
                    <lido:resourceRepresentation lido:type="image_master">
                        <!--objektin suuriresoluutioinen jpg-kuvatiedosto, joka näytetään käyttäjälle vain zoomattaessa ja tarjotaan ladattavaksi-->
                        <lido:linkResource lido:formatResource="jpg">
                            <!--tiedoston linkki, ilmoita elementin attribuutissa tiedostotyyppi jpg-->
                        </lido:linkResource>
                        <lido:resourceMeasurementsSet>
                            <lido:measurementType xml:lang="fi">koko</lido:measurementType>
                            <lido:measurementType xml:lang="en">size</lido:measurementType>
                            <lido:measurementUnit>
                                <!--tiedoston yksikkö, esim. bytes-->
                            </lido:measurementUnit>
                            <lido:measurementValue>
                                <!--tiedoston koko tavuina-->
                            </lido:measurementValue>
                        </lido:resourceMeasurementsSet>
                        <lido:resourceMeasurementsSet>
                            <lido:measurementType xml:lang="fi">leveys</lido:measurementType>
                            <lido:measurementType xml:lang="en">width</lido:measurementType>
                            <lido:measurementUnit>
                                <!--tiedoston yksikkö, esim pixel, cm, mm-->
                            </lido:measurementUnit>
                            <lido:measurementValue>
                                <!--kuvatiedoston leveys pikseleinä-->
                            </lido:measurementValue>
                        </lido:resourceMeasurementsSet>
                        <lido:resourceMeasurementsSet>
                            <lido:measurementType xml:lang="fi">korkeus</lido:measurementType>
                            <lido:measurementType xml:lang="en">height</lido:measurementType>
                            <lido:measurementUnit>
                                <!--tiedoston yksikkö, esim pixel, cm, mm-->
                            </lido:measurementUnit>
                            <lido:measurementValue>
                                <!--tiedoston korkeus pikseleinä-->
                            </lido:measurementValue>
                        </lido:resourceMeasurementsSet>
                    </lido:resourceRepresentation>
                    <lido:resourceRepresentation lido:type="image_original">
                        <!--objektin ladattava täysikokoinen kuvatiedosto: vain ladattavaksi, ei näytetä kuvana käyttöliitttymässä-->
                        <lido:linkResource lido:formatResource="tif">
                            <!--tiedoston latauslinkki, ilmoita elementin attribuutissa tiedostotyyppi tif-->
                        </lido:linkResource>
                        <lido:resourceMeasurementsSet>
                            <lido:measurementType xml:lang="fi">koko</lido:measurementType>
                            <lido:measurementType xml:lang="en">size</lido:measurementType>
                            <lido:measurementUnit>
                                <!--tiedoston yksikkö, esim. bytes-->
                            </lido:measurementUnit>
                            <lido:measurementValue>
                                <!--tiedoston koko tavuina-->
                            </lido:measurementValue>
                        </lido:resourceMeasurementsSet>
                        <lido:resourceMeasurementsSet>
                            <lido:measurementType xml:lang="fi">leveys</lido:measurementType>
                            <lido:measurementType xml:lang="en">width</lido:measurementType>
                            <lido:measurementUnit>
                                <!--tiedoston yksikkö, esim pixel, cm, mm-->
                            </lido:measurementUnit>
                            <lido:measurementValue>
                                <!--tiedoston leveys pikseleinä-->
                            </lido:measurementValue>
                        </lido:resourceMeasurementsSet>
                        <lido:resourceMeasurementsSet>
                            <lido:measurementType xml:lang="fi">korkeus</lido:measurementType>
                            <lido:measurementType xml:lang="en">height</lido:measurementType>
                            <lido:measurementUnit>
                                <!--tiedoston yksikkö, esim pixel, cm, mm-->
                            </lido:measurementUnit>
                            <lido:measurementValue>
                                <!--kuvatiedoston korkeus pikseleinä-->
                            </lido:measurementValue>
                        </lido:resourceMeasurementsSet>
                    </lido:resourceRepresentation>
                    <lido:resourceType>
                        <lido:term>
                            <!--tiedoston tyyppi esim. digitaalikuva, valokuva, negatiivi jne.-->
                        </lido:term>
                    </lido:resourceType>                    
                    <lido:resourceRelType>
                        <lido:term>
                            <!--tiedoston suhde objektiin esim. konservointikuva, dokumentointikuva, historiallinen kuva jne.-->
                        </lido:term>
                    </lido:resourceRelType>
                    <lido:resourcePerspective>
                        <lido:term>
                            <!--tiedoston suunta tai perspektiivi-->
                        </lido:term>
                    </lido:resourcePerspective>
                    <!--Ladattavalle tiedostolle on mahdollista tuoda myös kuvatiedoston alkuperäinen nimi esim. 062003:1.jpg-->
				   <lido:resourceDescription lido:type="displayLink"><!--objektin kuvatiedoston nimi--></lido:resourceDescription> 
                    <!--tiedoston kuvaus alueellisista, kronologisista tai kontekstuaalisista näkökohdista-->
                    <lido:resourceDescription lido:type="colour content"><!--esim. mustavalkoinen--></lido:resourceDescription>
                    <lido:resourceDateTaken>
                        <!--tiedoston kuvausaika-->
                        <lido:displayDate>
                            <!--kooste tiedoston kuvausajasta-->
                        </lido:displayDate>
                        <lido:date>
                            <lido:earliestDate>
                                <!--tiedoston varhaisin kuvausaika-->
                            </lido:earliestDate>
                            <lido:latestDate>
                                <!--tiedoston myöhäisin kuvausaika-->
                            </lido:latestDate>
                        </lido:date>
                    </lido:resourceDateTaken>                   
                    <lido:rightsResource> 
                       <!--objektista käyttäjälle tarjottavia digitaalisia resursseja/representaatioita koskevat oikeudet, 
                       esim taideteoksesta tai esineestä otettua valokuvaa koskevat oikeudet-->
                        <lido:rightsType>
                            <lido:conceptID lido:type="copyright">
                                <!--aineiston/digitaalisen resurssin lisenssi/käyttöoikeusmerkintä, esim. CC0, InC-->
                            </lido:conceptID>
                            <lido:term xml:lang="fi">
                                <!--lisenssiä/käyttöoikeusmerkintää koskeva selkokielinen käyttöoikeuskuvaus-->
                            </lido:term>
                            <lido:term xml:lang="en">
                                <!--lisenssiä/käyttöoikeusmerkintää koskeva selkokielinen käyttöoikeuskuvaus-->
                            </lido:term>
                            <lido:term xml:lang="sv">
                                <!--lisenssiä/käyttöoikeusmerkintää koskeva selkokielinen käyttöoikeuskuvaus-->
                            </lido:term>
                        </lido:rightsType>
                        <lido:rightsHolder>
                            <lido:legalBodyName>
                                <lido:appellationValue>
                                    <!--aineiston/digitaalisen resurssin oikeudenhaltija esim. museo-->
                                </lido:appellationValue>
                            </lido:legalBodyName>
                            <lido:legalBodyWeblink>
                                <!--aineiston/digitaalisen resurssin oikeudenhaltijan www-osoite-->
                            </lido:legalBodyWeblink>
                        </lido:rightsHolder>
                        <lido:creditLine>
                            <!--Vapaa tekstikenttä, jossa kerrotaan, kenelle aineiston krediitit kuuluvat. Elementin voi toistaa vain kieliversioille-->
                        </lido:creditLine>
                    </lido:rightsResource>
                </lido:resourceSet>                    
                <lido:resourceSet>     
                    <lido:resourceRepresentation lido:type="preview_3D">
                        <!--Finnassa näytettävä esikatselumalli-->
                        <lido:linkResource lido:formatResource="glTF">
                            <!--3D-esikatselumallin glTF-linkki-->
                        </lido:linkResource>                        
                    </lido:resourceRepresentation> 
                    <lido:resourceRepresentation lido:type="provided_3D">
                        <!--Finnan ulkopuolisessa palvelussa katseltava malli. Tätä mallia ei näytetä Finnassa.-->
                        <lido:linkResource lido:formatResource="glTF">
                            <!--3D-mallin glTF-linkki Finnan ulkopuoliseen palveluun-->
                        </lido:linkResource>
                    </lido:resourceRepresentation>    
                    <lido:resourceType>
                        <lido:term>
                            <!--tiedoston tyyppi esim. digitaalikuva, valokuva, negatiivi jne.-->
                        </lido:term>
                    </lido:resourceType>                    
                    <lido:resourceRelType>
                        <lido:term>
                            <!--tiedoston suhde objektiin esim. konservointikuva, dokumentointikuva, historiallinen kuva jne.-->
                        </lido:term>
                    </lido:resourceRelType>
                    <lido:resourcePerspective>
                        <lido:term>
                            <!--tiedoston suunta tai perspektiivi-->
                        </lido:term>
                    </lido:resourcePerspective>
                    <!--Ladattavalle tiedostolle on mahdollista tuoda myös kuvatiedoston alkuperäinen nimi esim. 062003:1.jpg-->
				   <lido:resourceDescription lido:type="displayLink"><!--objektin kuvatiedoston nimi--></lido:resourceDescription> 
                    <!--tiedoston kuvaus alueellisista, kronologisista tai kontekstuaalisista näkökohdista-->
                    <lido:resourceDescription lido:type="colour content"><!--esim. mustavalkoinen--></lido:resourceDescription>
                    <lido:resourceDateTaken>
                        <!--tiedoston kuvausaika-->
                        <lido:displayDate>
                            <!--kooste tiedoston kuvausajasta-->
                        </lido:displayDate>
                        <lido:date>
                            <lido:earliestDate>
                                <!--tiedoston varhaisin kuvausaika-->
                            </lido:earliestDate>
                            <lido:latestDate>
                                <!--tiedoston myöhäisin kuvausaika-->
                            </lido:latestDate>
                        </lido:date>
                    </lido:resourceDateTaken>                   
                    <lido:rightsResource> 
                       <!--objektista käyttäjälle tarjottavia digitaalisia resursseja/representaatioita koskevat oikeudet, 
                       esim taideteoksesta tai esineestä otettua valokuvaa koskevat oikeudet-->
                        <lido:rightsType>
                            <lido:conceptID lido:type="copyright">
                                <!--aineiston/digitaalisen resurssin lisenssi/käyttöoikeusmerkintä, esim. CC0, InC-->
                            </lido:conceptID>
                            <lido:term xml:lang="fi">
                                <!--lisenssiä/käyttöoikeusmerkintää koskeva selkokielinen käyttöoikeuskuvaus-->
                            </lido:term>
                            <lido:term xml:lang="en">
                                <!--lisenssiä/käyttöoikeusmerkintää koskeva selkokielinen käyttöoikeuskuvaus-->
                            </lido:term>
                            <lido:term xml:lang="sv">
                                <!--lisenssiä/käyttöoikeusmerkintää koskeva selkokielinen käyttöoikeuskuvaus-->
                            </lido:term>
                        </lido:rightsType>
                        <lido:rightsHolder>
                            <lido:legalBodyName>
                                <lido:appellationValue>
                                    <!--aineiston/digitaalisen resurssin oikeudenhaltija esim. museo-->
                                </lido:appellationValue>
                            </lido:legalBodyName>
                            <lido:legalBodyWeblink>
                                <!--aineiston/digitaalisen resurssin oikeudenhaltijan www-osoite-->
                            </lido:legalBodyWeblink>
                        </lido:rightsHolder>
                        <lido:creditLine>
                            <!--Vapaa tekstikenttä, jossa kerrotaan, kenelle aineiston krediitit kuuluvat. Elementin voi toistaa vain kieliversioille-->
                        </lido:creditLine>
                    </lido:rightsResource>
                </lido:resourceSet>                    
               <lido:resourceSet>                     
                    <lido:resourceRepresentation lido:type="preview_3D">
                        <!--Finnassa näytettävä esikatselumalli-->
                        <lido:linkResource lido:formatResource="glb">
                            <!--3D-esikatselumallin glb-linkki-->
                        </lido:linkResource>
                    </lido:resourceRepresentation>   
                    <lido:resourceRepresentation lido:type="provided_3D">
                        <!--Finnan ulkopuolisessa palvelussa katseltava malli. Tätä mallia ei näytetä Finnassa.-->
                        <lido:linkResource lido:formatResource="glb">
                            <!--3D-mallin glb-linkki Finnan ulkopuoliseen palveluun-->
                        </lido:linkResource>
                    </lido:resourceRepresentation>
                     <lido:resourceType>
                        <lido:term>
                            <!--tiedoston tyyppi esim. digitaalikuva, valokuva, negatiivi jne.-->
                        </lido:term>
                    </lido:resourceType>                    
                    <lido:resourceRelType>
                        <lido:term>
                            <!--tiedoston suhde objektiin esim. konservointikuva, dokumentointikuva, historiallinen kuva jne.-->
                        </lido:term>
                    </lido:resourceRelType>
                    <lido:resourcePerspective>
                        <lido:term>
                            <!--tiedoston suunta tai perspektiivi-->
                        </lido:term>
                    </lido:resourcePerspective>
                    <!--Ladattavalle tiedostolle on mahdollista tuoda myös kuvatiedoston alkuperäinen nimi esim. 062003:1.jpg-->
				   <lido:resourceDescription lido:type="displayLink"><!--objektin kuvatiedoston nimi--></lido:resourceDescription> 
                    <!--tiedoston kuvaus alueellisista, kronologisista tai kontekstuaalisista näkökohdista-->
                    <lido:resourceDescription lido:type="colour content"><!--esim. mustavalkoinen--></lido:resourceDescription>
                    <lido:resourceDateTaken>
                        <!--tiedoston kuvausaika-->
                        <lido:displayDate>
                            <!--kooste tiedoston kuvausajasta-->
                        </lido:displayDate>
                        <lido:date>
                            <lido:earliestDate>
                                <!--tiedoston varhaisin kuvausaika-->
                            </lido:earliestDate>
                            <lido:latestDate>
                                <!--tiedoston myöhäisin kuvausaika-->
                            </lido:latestDate>
                        </lido:date>
                    </lido:resourceDateTaken>                   
                    <lido:rightsResource> 
                       <!--objektista käyttäjälle tarjottavia digitaalisia resursseja/representaatioita koskevat oikeudet, 
                       esim taideteoksesta tai esineestä otettua valokuvaa koskevat oikeudet-->
                        <lido:rightsType>
                            <lido:conceptID lido:type="copyright">
                                <!--aineiston/digitaalisen resurssin lisenssi/käyttöoikeusmerkintä, esim. CC0, InC-->
                            </lido:conceptID>
                            <lido:term xml:lang="fi">
                                <!--lisenssiä/käyttöoikeusmerkintää koskeva selkokielinen käyttöoikeuskuvaus-->
                            </lido:term>
                            <lido:term xml:lang="en">
                                <!--lisenssiä/käyttöoikeusmerkintää koskeva selkokielinen käyttöoikeuskuvaus-->
                            </lido:term>
                            <lido:term xml:lang="sv">
                                <!--lisenssiä/käyttöoikeusmerkintää koskeva selkokielinen käyttöoikeuskuvaus-->
                            </lido:term>
                        </lido:rightsType>
                        <lido:rightsHolder>
                            <lido:legalBodyName>
                                <lido:appellationValue>
                                    <!--aineiston/digitaalisen resurssin oikeudenhaltija esim. museo-->
                                </lido:appellationValue>
                            </lido:legalBodyName>
                            <lido:legalBodyWeblink>
                                <!--aineiston/digitaalisen resurssin oikeudenhaltijan www-osoite-->
                            </lido:legalBodyWeblink>
                        </lido:rightsHolder>
                        <lido:creditLine>
                            <!--Vapaa tekstikenttä, jossa kerrotaan, kenelle aineiston krediitit kuuluvat. Elementin voi toistaa vain kieliversioille-->
                        </lido:creditLine>
                    </lido:rightsResource>
                </lido:resourceSet>                    
               <lido:resourceSet>         
                    <lido:resourceRepresentation lido:type="preview_video">
                        <!--Finnassa ladattava videolinkki-->
                        <lido:linkResource lido:formatResource="mp4">
                            <!--mp4-linkki-->
                        </lido:linkResource>                        
                    </lido:resourceRepresentation>  
                    <lido:resourceType>
                        <lido:term>
                            <!--tiedoston tyyppi esim. digitaalikuva, valokuva, negatiivi jne.-->
                        </lido:term>
                    </lido:resourceType>                    
                    <lido:resourceRelType>
                        <lido:term>
                            <!--tiedoston suhde objektiin esim. konservointikuva, dokumentointikuva, historiallinen kuva jne.-->
                        </lido:term>
                    </lido:resourceRelType>
                    <lido:resourcePerspective>
                        <lido:term>
                            <!--tiedoston suunta tai perspektiivi-->
                        </lido:term>
                    </lido:resourcePerspective>
                    <!--Ladattavalle tiedostolle on mahdollista tuoda myös kuvatiedoston alkuperäinen nimi esim. 062003:1.jpg-->
				   <lido:resourceDescription lido:type="displayLink"><!--objektin kuvatiedoston nimi--></lido:resourceDescription> 
                    <!--tiedoston kuvaus alueellisista, kronologisista tai kontekstuaalisista näkökohdista-->
                    <lido:resourceDescription lido:type="colour content"><!--esim. mustavalkoinen--></lido:resourceDescription>
                    <lido:resourceDateTaken>
                        <!--tiedoston kuvausaika-->
                        <lido:displayDate>
                            <!--kooste tiedoston kuvausajasta-->
                        </lido:displayDate>
                        <lido:date>
                            <lido:earliestDate>
                                <!--tiedoston varhaisin kuvausaika-->
                            </lido:earliestDate>
                            <lido:latestDate>
                                <!--tiedoston myöhäisin kuvausaika-->
                            </lido:latestDate>
                        </lido:date>
                    </lido:resourceDateTaken>                   
                    <lido:rightsResource> 
                       <!--objektista käyttäjälle tarjottavia digitaalisia resursseja/representaatioita koskevat oikeudet, 
                       esim taideteoksesta tai esineestä otettua valokuvaa koskevat oikeudet-->
                        <lido:rightsType>
                            <lido:conceptID lido:type="copyright">
                                <!--aineiston/digitaalisen resurssin lisenssi/käyttöoikeusmerkintä, esim. CC0, InC-->
                            </lido:conceptID>
                            <lido:term xml:lang="fi">
                                <!--lisenssiä/käyttöoikeusmerkintää koskeva selkokielinen käyttöoikeuskuvaus-->
                            </lido:term>
                            <lido:term xml:lang="en">
                                <!--lisenssiä/käyttöoikeusmerkintää koskeva selkokielinen käyttöoikeuskuvaus-->
                            </lido:term>
                            <lido:term xml:lang="sv">
                                <!--lisenssiä/käyttöoikeusmerkintää koskeva selkokielinen käyttöoikeuskuvaus-->
                            </lido:term>
                        </lido:rightsType>
                        <lido:rightsHolder>
                            <lido:legalBodyName>
                                <lido:appellationValue>
                                    <!--aineiston/digitaalisen resurssin oikeudenhaltija esim. museo-->
                                </lido:appellationValue>
                            </lido:legalBodyName>
                            <lido:legalBodyWeblink>
                                <!--aineiston/digitaalisen resurssin oikeudenhaltijan www-osoite-->
                            </lido:legalBodyWeblink>
                        </lido:rightsHolder>
                        <lido:creditLine>
                            <!--Vapaa tekstikenttä, jossa kerrotaan, kenelle aineiston krediitit kuuluvat. Elementin voi toistaa vain kieliversioille-->
                        </lido:creditLine>
                    </lido:rightsResource>
                </lido:resourceSet> 
               <lido:resourceSet>                   
                    <lido:resourceRepresentation lido:type="preview_audio">
                        <!--Finnassa ladattava audiolinkki-->
                        <lido:linkResource lido:formatResource="mp3">
                            <!--mp3-linkki-->
                        </lido:linkResource>                        
                    </lido:resourceRepresentation>
                    <lido:resourceType>
                        <lido:term>
                            <!--tiedoston tyyppi esim. digitaalikuva, valokuva, negatiivi jne.-->
                        </lido:term>
                    </lido:resourceType>                    
                    <lido:resourceRelType>
                        <lido:term>
                            <!--tiedoston suhde objektiin esim. konservointikuva, dokumentointikuva, historiallinen kuva jne.-->
                        </lido:term>
                    </lido:resourceRelType>
                    <lido:resourcePerspective>
                        <lido:term>
                            <!--tiedoston suunta tai perspektiivi-->
                        </lido:term>
                    </lido:resourcePerspective>
                    <!--Ladattavalle tiedostolle on mahdollista tuoda myös kuvatiedoston alkuperäinen nimi esim. 062003:1.jpg-->
				   <lido:resourceDescription lido:type="displayLink"><!--objektin kuvatiedoston nimi--></lido:resourceDescription> 
                    <!--tiedoston kuvaus alueellisista, kronologisista tai kontekstuaalisista näkökohdista-->
                    <lido:resourceDescription lido:type="colour content"><!--esim. mustavalkoinen--></lido:resourceDescription>
                    <lido:resourceDateTaken>
                        <!--tiedoston kuvausaika-->
                        <lido:displayDate>
                            <!--kooste tiedoston kuvausajasta-->
                        </lido:displayDate>
                        <lido:date>
                            <lido:earliestDate>
                                <!--tiedoston varhaisin kuvausaika-->
                            </lido:earliestDate>
                            <lido:latestDate>
                                <!--tiedoston myöhäisin kuvausaika-->
                            </lido:latestDate>
                        </lido:date>
                    </lido:resourceDateTaken>                   
                    <lido:rightsResource> 
                       <!--objektista käyttäjälle tarjottavia digitaalisia resursseja/representaatioita koskevat oikeudet, 
                       esim taideteoksesta tai esineestä otettua valokuvaa koskevat oikeudet-->
                        <lido:rightsType>
                            <lido:conceptID lido:type="copyright">
                                <!--aineiston/digitaalisen resurssin lisenssi/käyttöoikeusmerkintä, esim. CC0, InC-->
                            </lido:conceptID>
                            <lido:term xml:lang="fi">
                                <!--lisenssiä/käyttöoikeusmerkintää koskeva selkokielinen käyttöoikeuskuvaus-->
                            </lido:term>
                            <lido:term xml:lang="en">
                                <!--lisenssiä/käyttöoikeusmerkintää koskeva selkokielinen käyttöoikeuskuvaus-->
                            </lido:term>
                            <lido:term xml:lang="sv">
                                <!--lisenssiä/käyttöoikeusmerkintää koskeva selkokielinen käyttöoikeuskuvaus-->
                            </lido:term>
                        </lido:rightsType>
                        <lido:rightsHolder>
                            <lido:legalBodyName>
                                <lido:appellationValue>
                                    <!--aineiston/digitaalisen resurssin oikeudenhaltija esim. museo-->
                                </lido:appellationValue>
                            </lido:legalBodyName>
                            <lido:legalBodyWeblink>
                                <!--aineiston/digitaalisen resurssin oikeudenhaltijan www-osoite-->
                            </lido:legalBodyWeblink>
                        </lido:rightsHolder>
                        <lido:creditLine>
                            <!--Vapaa tekstikenttä, jossa kerrotaan, kenelle aineiston krediitit kuuluvat. Elementin voi toistaa vain kieliversioille-->
                        </lido:creditLine>
                    </lido:rightsResource>
                </lido:resourceSet>
                <lido:resourceSet> 
                    <lido:resourceRepresentation lido:type="preview_audio">
                        <!--Finnassa ladattava audiolinkki-->
                        <lido:linkResource lido:formatResource="wav">
                            <!--wav-linkki-->
                        </lido:linkResource>                        
                    </lido:resourceRepresentation>
                    <lido:resourceType>
                        <lido:term>
                            <!--tiedoston tyyppi esim. digitaalikuva, valokuva, negatiivi jne.-->
                        </lido:term>
                    </lido:resourceType>                    
                    <lido:resourceRelType>
                        <lido:term>
                            <!--tiedoston suhde objektiin esim. konservointikuva, dokumentointikuva, historiallinen kuva jne.-->
                        </lido:term>
                    </lido:resourceRelType>
                    <lido:resourcePerspective>
                        <lido:term>
                            <!--tiedoston suunta tai perspektiivi-->
                        </lido:term>
                    </lido:resourcePerspective>
                    <!--Ladattavalle tiedostolle on mahdollista tuoda myös kuvatiedoston alkuperäinen nimi esim. 062003:1.jpg-->
				   <lido:resourceDescription lido:type="displayLink"><!--objektin kuvatiedoston nimi--></lido:resourceDescription> 
                    <!--tiedoston kuvaus alueellisista, kronologisista tai kontekstuaalisista näkökohdista-->
                    <lido:resourceDescription lido:type="colour content"><!--esim. mustavalkoinen--></lido:resourceDescription>
                    <lido:resourceDateTaken>
                        <!--tiedoston kuvausaika-->
                        <lido:displayDate>
                            <!--kooste tiedoston kuvausajasta-->
                        </lido:displayDate>
                        <lido:date>
                            <lido:earliestDate>
                                <!--tiedoston varhaisin kuvausaika-->
                            </lido:earliestDate>
                            <lido:latestDate>
                                <!--tiedoston myöhäisin kuvausaika-->
                            </lido:latestDate>
                        </lido:date>
                    </lido:resourceDateTaken>                   
                    <lido:rightsResource> 
                       <!--objektista käyttäjälle tarjottavia digitaalisia resursseja/representaatioita koskevat oikeudet, 
                       esim taideteoksesta tai esineestä otettua valokuvaa koskevat oikeudet-->
                        <lido:rightsType>
                            <lido:conceptID lido:type="copyright">
                                <!--aineiston/digitaalisen resurssin lisenssi/käyttöoikeusmerkintä, esim. CC0, InC-->
                            </lido:conceptID>
                            <lido:term xml:lang="fi">
                                <!--lisenssiä/käyttöoikeusmerkintää koskeva selkokielinen käyttöoikeuskuvaus-->
                            </lido:term>
                            <lido:term xml:lang="en">
                                <!--lisenssiä/käyttöoikeusmerkintää koskeva selkokielinen käyttöoikeuskuvaus-->
                            </lido:term>
                            <lido:term xml:lang="sv">
                                <!--lisenssiä/käyttöoikeusmerkintää koskeva selkokielinen käyttöoikeuskuvaus-->
                            </lido:term>
                        </lido:rightsType>
                        <lido:rightsHolder>
                            <lido:legalBodyName>
                                <lido:appellationValue>
                                    <!--aineiston/digitaalisen resurssin oikeudenhaltija esim. museo-->
                                </lido:appellationValue>
                            </lido:legalBodyName>
                            <lido:legalBodyWeblink>
                                <!--aineiston/digitaalisen resurssin oikeudenhaltijan www-osoite-->
                            </lido:legalBodyWeblink>
                        </lido:rightsHolder>
                        <lido:creditLine>
                            <!--Vapaa tekstikenttä, jossa kerrotaan, kenelle aineiston krediitit kuuluvat. Elementin voi toistaa vain kieliversioille-->
                        </lido:creditLine>
                    </lido:rightsResource>
                </lido:resourceSet>
                <lido:resourceSet> 
                    <lido:resourceRepresentation lido:type="provided_text">
                        <!--Finnassa ladattava tekstilinkki-->
                        <lido:linkResource lido:formatResource="pdf">
                            <!--pdf-linkki-->
                        </lido:linkResource>                        
                    </lido:resourceRepresentation>
                    <lido:resourceType>
                        <lido:term>
                            <!--tiedoston tyyppi esim. digitaalikuva, valokuva, negatiivi jne.-->
                        </lido:term>
                    </lido:resourceType>                    
                    <lido:resourceRelType>
                        <lido:term>
                            <!--tiedoston suhde objektiin esim. konservointikuva, dokumentointikuva, historiallinen kuva jne.-->
                        </lido:term>
                    </lido:resourceRelType>
                    <lido:resourcePerspective>
                        <lido:term>
                            <!--tiedoston suunta tai perspektiivi-->
                        </lido:term>
                    </lido:resourcePerspective>
                    <!--Ladattavalle tiedostolle on mahdollista tuoda myös kuvatiedoston alkuperäinen nimi esim. 062003:1.jpg-->
				   <lido:resourceDescription lido:type="displayLink"><!--objektin kuvatiedoston nimi--></lido:resourceDescription> 
                    <!--tiedoston kuvaus alueellisista, kronologisista tai kontekstuaalisista näkökohdista-->
                    <lido:resourceDescription lido:type="colour content"><!--esim. mustavalkoinen--></lido:resourceDescription>
                    <lido:resourceDateTaken>
                        <!--tiedoston kuvausaika-->
                        <lido:displayDate>
                            <!--kooste tiedoston kuvausajasta-->
                        </lido:displayDate>
                        <lido:date>
                            <lido:earliestDate>
                                <!--tiedoston varhaisin kuvausaika-->
                            </lido:earliestDate>
                            <lido:latestDate>
                                <!--tiedoston myöhäisin kuvausaika-->
                            </lido:latestDate>
                        </lido:date>
                    </lido:resourceDateTaken>                   
                    <lido:rightsResource> 
                       <!--objektista käyttäjälle tarjottavia digitaalisia resursseja/representaatioita koskevat oikeudet, 
                       esim taideteoksesta tai esineestä otettua valokuvaa koskevat oikeudet-->
                        <lido:rightsType>
                            <lido:conceptID lido:type="copyright">
                                <!--aineiston/digitaalisen resurssin lisenssi/käyttöoikeusmerkintä, esim. CC0, InC-->
                            </lido:conceptID>
                            <lido:term xml:lang="fi">
                                <!--lisenssiä/käyttöoikeusmerkintää koskeva selkokielinen käyttöoikeuskuvaus-->
                            </lido:term>
                            <lido:term xml:lang="en">
                                <!--lisenssiä/käyttöoikeusmerkintää koskeva selkokielinen käyttöoikeuskuvaus-->
                            </lido:term>
                            <lido:term xml:lang="sv">
                                <!--lisenssiä/käyttöoikeusmerkintää koskeva selkokielinen käyttöoikeuskuvaus-->
                            </lido:term>
                        </lido:rightsType>
                        <lido:rightsHolder>
                            <lido:legalBodyName>
                                <lido:appellationValue>
                                    <!--aineiston/digitaalisen resurssin oikeudenhaltija esim. museo-->
                                </lido:appellationValue>
                            </lido:legalBodyName>
                            <lido:legalBodyWeblink>
                                <!--aineiston/digitaalisen resurssin oikeudenhaltijan www-osoite-->
                            </lido:legalBodyWeblink>
                        </lido:rightsHolder>
                        <lido:creditLine>
                            <!--Vapaa tekstikenttä, jossa kerrotaan, kenelle aineiston krediitit kuuluvat. Elementin voi toistaa vain kieliversioille-->
                        </lido:creditLine>
                    </lido:rightsResource>
                </lido:resourceSet>
                <lido:resourceSet> 
                    <lido:resourceRepresentation lido:type="provided_text">
                        <!--Finnassa ladattava tekstilinkki-->
                        <lido:linkResource lido:formatResource="docx">
                            <!--docx-linkki-->
                        </lido:linkResource>                        
                    </lido:resourceRepresentation>
                    <lido:resourceType>
                        <lido:term>
                            <!--tiedoston tyyppi esim. digitaalikuva, valokuva, negatiivi jne.-->
                        </lido:term>
                    </lido:resourceType>                    
                    <lido:resourceRelType>
                        <lido:term>
                            <!--tiedoston suhde objektiin esim. konservointikuva, dokumentointikuva, historiallinen kuva jne.-->
                        </lido:term>
                    </lido:resourceRelType>
                    <lido:resourcePerspective>
                        <lido:term>
                            <!--tiedoston suunta tai perspektiivi-->
                        </lido:term>
                    </lido:resourcePerspective>
                    <!--Ladattavalle tiedostolle on mahdollista tuoda myös kuvatiedoston alkuperäinen nimi esim. 062003:1.jpg-->
				   <lido:resourceDescription lido:type="displayLink"><!--objektin kuvatiedoston nimi--></lido:resourceDescription> 
                    <!--tiedoston kuvaus alueellisista, kronologisista tai kontekstuaalisista näkökohdista-->
                    <lido:resourceDescription lido:type="colour content"><!--esim. mustavalkoinen--></lido:resourceDescription>
                    <lido:resourceDateTaken>
                        <!--tiedoston kuvausaika-->
                        <lido:displayDate>
                            <!--kooste tiedoston kuvausajasta-->
                        </lido:displayDate>
                        <lido:date>
                            <lido:earliestDate>
                                <!--tiedoston varhaisin kuvausaika-->
                            </lido:earliestDate>
                            <lido:latestDate>
                                <!--tiedoston myöhäisin kuvausaika-->
                            </lido:latestDate>
                        </lido:date>
                    </lido:resourceDateTaken>                   
                    <lido:rightsResource> 
                       <!--objektista käyttäjälle tarjottavia digitaalisia resursseja/representaatioita koskevat oikeudet, 
                       esim taideteoksesta tai esineestä otettua valokuvaa koskevat oikeudet-->
                        <lido:rightsType>
                            <lido:conceptID lido:type="copyright">
                                <!--aineiston/digitaalisen resurssin lisenssi/käyttöoikeusmerkintä, esim. CC0, InC-->
                            </lido:conceptID>
                            <lido:term xml:lang="fi">
                                <!--lisenssiä/käyttöoikeusmerkintää koskeva selkokielinen käyttöoikeuskuvaus-->
                            </lido:term>
                            <lido:term xml:lang="en">
                                <!--lisenssiä/käyttöoikeusmerkintää koskeva selkokielinen käyttöoikeuskuvaus-->
                            </lido:term>
                            <lido:term xml:lang="sv">
                                <!--lisenssiä/käyttöoikeusmerkintää koskeva selkokielinen käyttöoikeuskuvaus-->
                            </lido:term>
                        </lido:rightsType>
                        <lido:rightsHolder>
                            <lido:legalBodyName>
                                <lido:appellationValue>
                                    <!--aineiston/digitaalisen resurssin oikeudenhaltija esim. museo-->
                                </lido:appellationValue>
                            </lido:legalBodyName>
                            <lido:legalBodyWeblink>
                                <!--aineiston/digitaalisen resurssin oikeudenhaltijan www-osoite-->
                            </lido:legalBodyWeblink>
                        </lido:rightsHolder>
                        <lido:creditLine>
                            <!--Vapaa tekstikenttä, jossa kerrotaan, kenelle aineiston krediitit kuuluvat. Elementin voi toistaa vain kieliversioille-->
                        </lido:creditLine>
                    </lido:rightsResource>
                </lido:resourceSet> 
                <lido:resourceSet> 
                    <lido:resourceRepresentation lido:type="provided_text">
                        <!--Finnassa ladattava tekstilinkki-->
                        <lido:linkResource lido:formatResource="xlsx">
                            <!--xlsx-linkki-->
                        </lido:linkResource>                        
                    </lido:resourceRepresentation><lido:resourceType>
                        <lido:term>
                            <!--tiedoston tyyppi esim. digitaalikuva, valokuva, negatiivi jne.-->
                        </lido:term>
                    </lido:resourceType>                    
                    <lido:resourceRelType>
                        <lido:term>
                            <!--tiedoston suhde objektiin esim. konservointikuva, dokumentointikuva, historiallinen kuva jne.-->
                        </lido:term>
                    </lido:resourceRelType>
                    <lido:resourcePerspective>
                        <lido:term>
                            <!--tiedoston suunta tai perspektiivi-->
                        </lido:term>
                    </lido:resourcePerspective>
                    <!--Ladattavalle tiedostolle on mahdollista tuoda myös kuvatiedoston alkuperäinen nimi esim. 062003:1.jpg-->
				   <lido:resourceDescription lido:type="displayLink"><!--objektin kuvatiedoston nimi--></lido:resourceDescription> 
                    <!--tiedoston kuvaus alueellisista, kronologisista tai kontekstuaalisista näkökohdista-->
                    <lido:resourceDescription lido:type="colour content"><!--esim. mustavalkoinen--></lido:resourceDescription>
                    <lido:resourceDateTaken>
                        <!--tiedoston kuvausaika-->
                        <lido:displayDate>
                            <!--kooste tiedoston kuvausajasta-->
                        </lido:displayDate>
                        <lido:date>
                            <lido:earliestDate>
                                <!--tiedoston varhaisin kuvausaika-->
                            </lido:earliestDate>
                            <lido:latestDate>
                                <!--tiedoston myöhäisin kuvausaika-->
                            </lido:latestDate>
                        </lido:date>
                    </lido:resourceDateTaken>                   
                    <lido:rightsResource> 
                       <!--objektista käyttäjälle tarjottavia digitaalisia resursseja/representaatioita koskevat oikeudet, 
                       esim taideteoksesta tai esineestä otettua valokuvaa koskevat oikeudet-->
                        <lido:rightsType>
                            <lido:conceptID lido:type="copyright">
                                <!--aineiston/digitaalisen resurssin lisenssi/käyttöoikeusmerkintä, esim. CC0, InC-->
                            </lido:conceptID>
                            <lido:term xml:lang="fi">
                                <!--lisenssiä/käyttöoikeusmerkintää koskeva selkokielinen käyttöoikeuskuvaus-->
                            </lido:term>
                            <lido:term xml:lang="en">
                                <!--lisenssiä/käyttöoikeusmerkintää koskeva selkokielinen käyttöoikeuskuvaus-->
                            </lido:term>
                            <lido:term xml:lang="sv">
                                <!--lisenssiä/käyttöoikeusmerkintää koskeva selkokielinen käyttöoikeuskuvaus-->
                            </lido:term>
                        </lido:rightsType>
                        <lido:rightsHolder>
                            <lido:legalBodyName>
                                <lido:appellationValue>
                                    <!--aineiston/digitaalisen resurssin oikeudenhaltija esim. museo-->
                                </lido:appellationValue>
                            </lido:legalBodyName>
                            <lido:legalBodyWeblink>
                                <!--aineiston/digitaalisen resurssin oikeudenhaltijan www-osoite-->
                            </lido:legalBodyWeblink>
                        </lido:rightsHolder>
                        <lido:creditLine>
                            <!--Vapaa tekstikenttä, jossa kerrotaan, kenelle aineiston krediitit kuuluvat. Elementin voi toistaa vain kieliversioille-->
                        </lido:creditLine>
                    </lido:rightsResource>
                </lido:resourceSet>  
           </lido:resourceWrap>
        </lido:administrativeMetadata>
    </lido:lido>
</lido:lidoWrap>



